/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.List;
import ratpack.guice.internal.GuiceUtil;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;

public class InjectorBackedRegistry
implements Registry {
    final Injector injector;

    public InjectorBackedRegistry(Injector injector) {
        this.injector = injector;
    }

    public <O> O get(Class<O> type) throws NotInRegistryException {
        O object = this.maybeGet(type);
        if (object == null) {
            throw new NotInRegistryException(type);
        }
        return object;
    }

    public <T> T maybeGet(Class<T> type) {
        Binding existingBinding = this.injector.getExistingBinding(Key.get(type));
        if (existingBinding == null) {
            return null;
        }
        return (T)existingBinding.getProvider().get();
    }

    public <O> List<O> getAll(Class<O> type) {
        return GuiceUtil.ofType(this.injector, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectorBackedRegistry that = (InjectorBackedRegistry)o;
        return this.injector.equals(that.injector);
    }

    public int hashCode() {
        return this.injector.hashCode();
    }
}

