/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.util.Map;
import ratpack.func.Action;
import ratpack.util.ExceptionUtils;

public abstract class GuiceUtil {
    private GuiceUtil() {
    }

    public static <T> void eachOfType(Injector injector, TypeLiteral<T> type, Action<T> action) {
        Map allBindings = injector.getAllBindings();
        for (Map.Entry keyBindingEntry : allBindings.entrySet()) {
            Class rawType = ((Key)keyBindingEntry.getKey()).getTypeLiteral().getRawType();
            if (!type.getRawType().isAssignableFrom(rawType)) continue;
            Object thing = ((Binding)keyBindingEntry.getValue()).getProvider().get();
            try {
                action.execute(thing);
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }
    }

    public static <T> ImmutableList<T> ofType(Injector injector, Class<T> type) {
        return GuiceUtil.ofType(injector, TypeLiteral.get(type));
    }

    public static <T> ImmutableList<T> ofType(Injector injector, TypeLiteral<T> type) {
        final ImmutableList.Builder listBuilder = ImmutableList.builder();
        GuiceUtil.eachOfType(injector, type, new Action<T>(){

            public void execute(T thing) {
                listBuilder.add(thing);
            }
        });
        return listBuilder.build();
    }
}

