/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.inject.AbstractModule;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provides;
import io.netty.buffer.ByteBufAllocator;
import ratpack.handling.Background;
import ratpack.handling.Context;
import ratpack.handling.Foreground;
import ratpack.handling.NoBoundContextException;
import ratpack.handling.ReadOnlyContext;
import ratpack.launch.LaunchConfig;

public class DefaultRatpackModule
extends AbstractModule {
    private final LaunchConfig launchConfig;

    public DefaultRatpackModule(LaunchConfig launchConfig) {
        this.launchConfig = launchConfig;
    }

    protected void configure() {
        this.bind(LaunchConfig.class).toInstance((Object)this.launchConfig);
    }

    @Provides
    ByteBufAllocator bufferAllocator(LaunchConfig launchConfig) {
        return launchConfig.getBufferAllocator();
    }

    @Provides
    Background background(LaunchConfig launchConfig) {
        return launchConfig.getBackground();
    }

    @Provides
    Foreground foreground(LaunchConfig launchConfig) {
        return launchConfig.getForeground();
    }

    @Provides
    ReadOnlyContext context(Foreground foreground) {
        try {
            return foreground.getContext();
        }
        catch (NoBoundContextException e) {
            throw new OutOfScopeException("Cannot provide an instance of " + Context.class.getName() + " as none is bound to the current thread (are you outside of a managed thread?)");
        }
    }
}

