/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Provider;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.func.Transformer;
import ratpack.guice.GuiceBackedHandlerFactory;
import ratpack.guice.HandlerDecoratingModule;
import ratpack.guice.ModuleRegistry;
import ratpack.guice.internal.DefaultRatpackModule;
import ratpack.guice.internal.InjectorBindingHandler;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.internal.ClientErrorForwardingHandler;
import ratpack.handling.internal.FactoryHandler;
import ratpack.launch.LaunchConfig;
import ratpack.registry.NotInRegistryException;
import ratpack.reload.internal.ClassUtil;
import ratpack.reload.internal.ReloadableFileBackedFactory;
import ratpack.util.ExceptionUtils;

public class DefaultGuiceBackedHandlerFactory
implements GuiceBackedHandlerFactory {
    private final LaunchConfig launchConfig;

    public DefaultGuiceBackedHandlerFactory(LaunchConfig launchConfig) {
        this.launchConfig = launchConfig;
    }

    @Override
    public Handler create(final Action<? super ModuleRegistry> modulesAction, final Transformer<? super Module, ? extends Injector> moduleTransformer, final Transformer<? super Injector, ? extends Handler> injectorTransformer) throws Exception {
        File classFile;
        if (this.launchConfig.isReloadable() && (classFile = ClassUtil.getClassFile(modulesAction)) != null) {
            ReloadableFileBackedFactory factory = new ReloadableFileBackedFactory(classFile.toPath(), true, (ReloadableFileBackedFactory.Producer)new ReloadableFileBackedFactory.Producer<InjectorBindingHandler>(){

                public InjectorBindingHandler produce(Path file, ByteBuf bytes) throws Exception {
                    return DefaultGuiceBackedHandlerFactory.this.doCreate((Action<? super ModuleRegistry>)modulesAction, (Transformer<? super Module, ? extends Injector>)moduleTransformer, (Transformer<? super Injector, ? extends Handler>)injectorTransformer);
                }
            });
            return new FactoryHandler((Factory)factory);
        }
        return this.doCreate(modulesAction, moduleTransformer, injectorTransformer);
    }

    private InjectorBindingHandler doCreate(Action<? super ModuleRegistry> modulesAction, Transformer<? super Module, ? extends Injector> moduleTransformer, Transformer<? super Injector, ? extends Handler> injectorTransformer) throws Exception {
        DefaultModuleRegistry moduleRegistry = new DefaultModuleRegistry(this.launchConfig);
        this.registerDefaultModules(moduleRegistry);
        try {
            modulesAction.execute((Object)moduleRegistry);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck((Throwable)e);
        }
        Module masterModule = null;
        List modules = moduleRegistry.getModules();
        for (Module module : modules) {
            if (masterModule == null) {
                masterModule = module;
                continue;
            }
            masterModule = Modules.override((Module[])new Module[]{masterModule}).with(new Module[]{module});
        }
        Injector injector = (Injector)moduleTransformer.transform(masterModule);
        LinkedList init = moduleRegistry.init;
        for (Action initAction : init) {
            initAction.execute((Object)injector);
        }
        Handler decorated = (Handler)injectorTransformer.transform((Object)injector);
        ArrayList modulesReversed = new ArrayList(modules);
        Collections.reverse(modulesReversed);
        for (Module module : modulesReversed) {
            if (!(module instanceof HandlerDecoratingModule)) continue;
            decorated = ((HandlerDecoratingModule)module).decorate(injector, decorated);
        }
        decorated = Handlers.chain((Handler[])new Handler[]{this.decorateHandler(decorated), new ClientErrorForwardingHandler(404)});
        return new InjectorBindingHandler(injector, decorated);
    }

    protected Handler decorateHandler(Handler handler) {
        return handler;
    }

    protected void registerDefaultModules(ModuleRegistry moduleRegistry) {
        moduleRegistry.register((Object)new DefaultRatpackModule(this.launchConfig));
    }

    private static class DefaultModuleRegistry
    implements ModuleRegistry {
        private final Map<Class<? extends Module>, Module> modules = new LinkedHashMap<Class<? extends Module>, Module>();
        private final LaunchConfig launchConfig;
        private final LinkedList<Action<Binder>> actions = new LinkedList();
        private final LinkedList<Action<Injector>> init = new LinkedList();

        public DefaultModuleRegistry(LaunchConfig launchConfig) {
            this.launchConfig = launchConfig;
        }

        @Override
        public LaunchConfig getLaunchConfig() {
            return this.launchConfig;
        }

        @Override
        public void bind(final Class<?> type) {
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) {
                    binder.bind(type);
                }
            });
        }

        @Override
        public <T> void bind(final Class<T> publicType, final Class<? extends T> implType) {
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) {
                    binder.bind(publicType).to(implType);
                }
            });
        }

        @Override
        public <T> void bind(final Class<? super T> publicType, final T instance) {
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) {
                    binder.bind(publicType).toInstance(instance);
                }
            });
        }

        @Override
        public <T> void bind(final T instance) {
            final Class<?> type = instance.getClass();
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) {
                    binder.bind(type).toInstance(instance);
                }
            });
        }

        @Override
        public <T> void provider(final Class<T> publicType, final Class<? extends Provider<? extends T>> providerType) {
            this.actions.add(new Action<Binder>(){

                public void execute(Binder binder) {
                    binder.bind(publicType).toProvider(providerType);
                }
            });
        }

        public void register(Module module) {
            this.register(module.getClass(), module);
        }

        public <O extends Module> void registerLazy(Class<O> type, Factory<? extends O> factory) {
            this.register(type, (Module)factory.create());
        }

        public <O extends Module> void register(Class<O> type, O module) {
            if (this.modules.containsKey(type)) {
                Module existing = this.modules.get(type);
                throw new IllegalArgumentException(String.format("Module '%s' is already registered with type '%s' (attempting to register '%s')", existing, type, module));
            }
            this.modules.put(type, module);
        }

        public <T> T get(Class<T> moduleType) {
            Module module = this.modules.get(moduleType);
            if (module == null) {
                throw new NotInRegistryException(moduleType);
            }
            return moduleType.cast(module);
        }

        public <O> List<O> getAll(Class<O> type) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Module module : this.modules.values()) {
                if (!type.isInstance(module)) continue;
                Module cast = module;
                builder.add((Object)cast);
            }
            return builder.build();
        }

        public <O> O maybeGet(Class<O> type) {
            Module module = this.modules.get(type);
            if (module == null) {
                return null;
            }
            return type.cast(module);
        }

        public <T extends Module> void remove(Class<T> moduleType) {
            if (!this.modules.containsKey(moduleType)) {
                throw new NotInRegistryException(moduleType);
            }
            this.modules.remove(moduleType);
        }

        private List<Module> getModules() {
            return ImmutableList.builder().addAll(this.modules.values()).add((Object)this.createOverrideModule()).build();
        }

        private Module createOverrideModule() {
            return new Module(){

                public void configure(Binder binder) {
                    for (Action binderAction : DefaultModuleRegistry.this.actions) {
                        try {
                            binderAction.execute((Object)binder);
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.uncheck((Throwable)e);
                        }
                    }
                }
            };
        }

        @Override
        public void init(Action<Injector> action) {
            this.init.add(action);
        }

        @Override
        public void init(final Class<? extends Runnable> clazz) {
            this.init.add(new Action<Injector>(){

                public void execute(Injector injector) throws Exception {
                    ((Runnable)injector.getInstance(clazz)).run();
                }
            });
        }
    }
}

