/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Optional;
import org.reactivestreams.Publisher;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.form.internal.FormParser;
import ratpack.guice.ExecutionScoped;
import ratpack.guice.internal.ExecutionScope;
import ratpack.handling.Redirector;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.client.HttpClient;
import ratpack.registry.Registry;
import ratpack.render.Renderable;
import ratpack.render.Renderer;
import ratpack.server.PublicAddress;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;
import ratpack.sse.ServerSentEventStreamClient;

public class RatpackBaseRegistryModule
extends AbstractModule {
    private final Registry baseRegistry;

    public RatpackBaseRegistryModule(Registry baseRegistry) {
        this.baseRegistry = baseRegistry;
    }

    protected void configure() {
        this.bindScope(ExecutionScoped.class, new ExecutionScope());
        ImmutableList simpleTypes = ImmutableList.of(ServerConfig.class, ByteBufAllocator.class, ExecController.class, MimeTypes.class, PublicAddress.class, Redirector.class, ClientErrorHandler.class, ServerErrorHandler.class, RatpackServer.class);
        ImmutableList genericTypes = ImmutableList.of((Object)new TypeToken<Renderer<Path>>(){}, (Object)new TypeToken<Renderer<Promise>>(){}, (Object)new TypeToken<Renderer<Publisher>>(){}, (Object)new TypeToken<Renderer<Renderable>>(){}, (Object)new TypeToken<Renderer<CharSequence>>(){});
        ImmutableList setTypes = ImmutableList.of(FormParser.class);
        ImmutableList optionalTypes = ImmutableList.of(FileSystemBinding.class);
        simpleTypes.stream().forEach(t -> this.simpleBind((Class)t));
        genericTypes.stream().forEach(t -> this.genericBind((TypeToken)t));
        setTypes.stream().forEach(t -> this.setBind((Class)t));
        optionalTypes.stream().forEach(t -> this.optionalBind((Class)t));
    }

    private <T> void simpleBind(Class<T> type) {
        this.bind(type).toProvider(() -> this.baseRegistry.get(type));
    }

    private <T> void genericBind(TypeToken<T> typeToken) {
        TypeLiteral typeLiteral = TypeLiteral.get((Type)typeToken.getType());
        this.bind(typeLiteral).toProvider(() -> this.baseRegistry.get(typeToken));
    }

    private <T> void setBind(Class<T> type) {
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), type);
        this.baseRegistry.getAll(type).forEach(instance -> setBinder.addBinding().toInstance(instance));
    }

    private <T> void optionalBind(Class<T> type) {
        Optional optional = this.baseRegistry.maybeGet(type);
        if (optional.isPresent()) {
            this.bind(type).toProvider(() -> this.baseRegistry.get(type));
        }
    }

    @Provides
    HttpClient httpClient(ExecController execController, ByteBufAllocator byteBufAllocator, ServerConfig serverConfig) {
        return HttpClient.httpClient((ExecController)execController, (ByteBufAllocator)byteBufAllocator, (int)serverConfig.getMaxContentLength());
    }

    @Provides
    ServerSentEventStreamClient sseClient(ExecController execController, ByteBufAllocator byteBufAllocator) {
        return ServerSentEventStreamClient.sseStreamClient((ExecController)execController, (ByteBufAllocator)byteBufAllocator);
    }

    @Provides
    @ExecutionScoped
    Execution execution() {
        return Execution.current();
    }

    @Provides
    @ExecutionScoped
    Request request(Execution execution) throws Throwable {
        return (Request)execution.maybeGet(Request.class).orElseThrow(() -> {
            throw new RuntimeException("Cannot inject Request in execution scope as execution has no request object - this execution is not processing a request");
        });
    }

    @Provides
    @ExecutionScoped
    Response response(Execution execution) throws Throwable {
        return (Response)execution.maybeGet(Response.class).orElseThrow(() -> {
            throw new RuntimeException("Cannot inject Response in execution scope as execution has no response object - this execution is not processing a request");
        });
    }
}

