/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import java.util.Map;
import ratpack.exec.Execution;
import ratpack.exec.UnmanagedThreadException;

public class ExecutionScope
implements Scope {
    public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
        return () -> {
            Map<Key<?>, Object> scopedObjects = this.getScopedObjectMap(key);
            Object current = scopedObjects.get(key);
            if (current == null && !scopedObjects.containsKey(key)) {
                current = unscoped.get();
                if (Scopes.isCircularProxy((Object)current)) {
                    return current;
                }
                scopedObjects.put(key, current);
            }
            return current;
        };
    }

    private <T> Map<Key<?>, Object> getScopedObjectMap(Key<T> key) {
        try {
            Execution execution = Execution.current();
            return execution.maybeGet(Store.class).orElseGet(() -> {
                Store store = new Store();
                execution.add(Store.class, (Object)store);
                return store;
            }).map;
        }
        catch (UnmanagedThreadException e) {
            throw new OutOfScopeException("Cannot access " + key + " outside of an execution");
        }
    }

    private static class Store {
        private final Map<Key<?>, Object> map = Maps.newHashMap();

        private Store() {
        }
    }
}

