/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.util.Modules;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.func.Pair;
import ratpack.guice.BindingsSpec;
import ratpack.guice.internal.DefaultBindingsSpec;
import ratpack.guice.internal.InjectorRegistryBacking;
import ratpack.guice.internal.JustInTimeInjectorRegistry;
import ratpack.guice.internal.RatpackBaseRegistryModule;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBacking;
import ratpack.server.ServerConfig;
import ratpack.util.Exceptions;

public abstract class Guice {
    private Guice() {
    }

    public static Registry justInTimeRegistry(Injector injector) {
        return new JustInTimeInjectorRegistry(injector);
    }

    public static Registry registry(Injector injector) {
        return Registries.backedRegistry((RegistryBacking)new InjectorRegistryBacking(injector));
    }

    public static Function<Registry, Registry> registry(Action<? super BindingsSpec> bindings) {
        return baseRegistry -> Guice.registry(bindings, baseRegistry, Guice.newInjectorFactory((ServerConfig)baseRegistry.get(ServerConfig.class)));
    }

    public static Function<Registry, Registry> registry(Injector parentInjector, Action<? super BindingsSpec> bindings) {
        return baseRegistry -> Guice.registry(bindings, baseRegistry, Guice.childInjectorFactory(parentInjector));
    }

    private static Registry registry(Action<? super BindingsSpec> bindings, Registry baseRegistry, Function<Module, Injector> injectorFactory) throws Exception {
        Pair<List<Module>, Injector> pair = Guice.buildInjector(baseRegistry, bindings, injectorFactory);
        return Guice.registry((Injector)pair.right);
    }

    public static Function<Module, Injector> newInjectorFactory(ServerConfig serverConfig) {
        Stage stage = serverConfig.isDevelopment() ? Stage.DEVELOPMENT : Stage.PRODUCTION;
        return from -> from == null ? com.google.inject.Guice.createInjector((Stage)stage, (Module[])new Module[0]) : com.google.inject.Guice.createInjector((Stage)stage, (Module[])new Module[]{from});
    }

    private static Function<Module, Injector> childInjectorFactory(Injector parent) {
        return from -> from == null ? parent.createChildInjector(new Module[0]) : parent.createChildInjector(new Module[]{from});
    }

    private static Pair<List<Module>, Injector> buildInjector(Registry baseRegistry, Action<? super BindingsSpec> bindingsAction, Function<? super Module, ? extends Injector> injectorFactory) throws Exception {
        LinkedList binderActions = Lists.newLinkedList();
        LinkedList modules = Lists.newLinkedList();
        DefaultBindingsSpec bindings = new DefaultBindingsSpec((ServerConfig)baseRegistry.get(ServerConfig.class), binderActions, modules);
        bindings.add((Module)new RatpackBaseRegistryModule(baseRegistry));
        try {
            bindingsAction.execute((Object)bindings);
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
        modules.add(new AdHocModule(binderActions));
        Module masterModule = (Module)modules.stream().reduce((acc, next) -> Modules.override((Module[])new Module[]{acc}).with(new Module[]{next})).get();
        Injector injector = (Injector)injectorFactory.apply((Object)masterModule);
        Collections.reverse(modules);
        return Pair.of((Object)modules, (Object)injector);
    }

    private static class AdHocModule
    implements Module {
        private final List<Action<? super Binder>> binderActions;

        public AdHocModule(List<Action<? super Binder>> binderActions) {
            this.binderActions = binderActions;
        }

        public void configure(Binder binder) {
            for (Action<? super Binder> binderAction : this.binderActions) {
                binderAction.toConsumer().accept(binder);
            }
        }
    }
}

