/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice;

import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import ratpack.func.Action;
import ratpack.guice.ConfigurableModule;
import ratpack.guice.internal.GuiceUtil;
import ratpack.server.ServerConfig;
import ratpack.util.Exceptions;
import ratpack.util.Types;

public interface BindingsSpec {
    public ServerConfig getServerConfig();

    public BindingsSpec add(Module var1);

    public BindingsSpec add(Class<? extends Module> var1);

    public <C, T extends ConfigurableModule<C>> BindingsSpec add(Class<T> var1, Action<? super C> var2);

    public <C> BindingsSpec add(ConfigurableModule<C> var1, Action<? super C> var2);

    public <C, T extends ConfigurableModule<C>> BindingsSpec addConfig(Class<T> var1, C var2, Action<? super C> var3);

    default public <C, T extends ConfigurableModule<C>> BindingsSpec addConfig(Class<T> moduleClass, C config) {
        return this.addConfig(moduleClass, config, Action.noop());
    }

    public <C> BindingsSpec addConfig(ConfigurableModule<C> var1, C var2, Action<? super C> var3);

    default public <C, T extends ConfigurableModule<C>> BindingsSpec addConfig(T moduleClass, C config) {
        return this.addConfig(moduleClass, config, Action.noop());
    }

    public BindingsSpec binder(Action<? super Binder> var1);

    default public <T> BindingsSpec multiBinder(TypeToken<T> type, Action<? super Multibinder<T>> action) throws Exception {
        return this.binder((Action<? super Binder>)((Action)b -> action.execute((Object)Multibinder.newSetBinder((Binder)b, GuiceUtil.toTypeLiteral(type)))));
    }

    default public <T> BindingsSpec multiBinder(TypeLiteral<T> type, Action<? super Multibinder<T>> action) throws Exception {
        return this.multiBinder(GuiceUtil.toTypeToken(type), action);
    }

    default public <T> BindingsSpec multiBinder(Class<T> type, Action<? super Multibinder<T>> action) throws Exception {
        return this.multiBinder(TypeToken.of(type), action);
    }

    default public BindingsSpec bind(Class<?> type) {
        return this.binder((Action<? super Binder>)((Action)binder -> binder.bind(type)));
    }

    default public <T> BindingsSpec multiBind(Class<T> type) {
        return (BindingsSpec)Exceptions.uncheck(() -> this.multiBinder(type, b -> b.addBinding().to(type)));
    }

    default public <T> BindingsSpec bind(Class<T> publicType, Class<? extends T> implType) {
        return this.bind(TypeLiteral.get(publicType), implType);
    }

    default public <T> BindingsSpec bind(TypeToken<T> publicType, Class<? extends T> implType) {
        return this.bind(GuiceUtil.toTypeLiteral(publicType), implType);
    }

    default public <T> BindingsSpec bind(TypeLiteral<T> publicType, Class<? extends T> implType) {
        return this.binder((Action<? super Binder>)((Action)binder -> binder.bind(publicType).to(implType)));
    }

    default public <T> BindingsSpec multiBind(TypeLiteral<T> publicType, Class<? extends T> implType) {
        return (BindingsSpec)Exceptions.uncheck(() -> this.multiBinder(publicType, b -> b.addBinding().to(implType)));
    }

    default public <T> BindingsSpec multiBind(Class<T> publicType, Class<? extends T> implType) {
        return this.multiBind(TypeLiteral.get(publicType), implType);
    }

    default public <T> BindingsSpec multiBind(TypeToken<T> publicType, Class<? extends T> implType) {
        return this.multiBind(GuiceUtil.toTypeLiteral(publicType), implType);
    }

    default public <T> BindingsSpec bindInstance(TypeLiteral<? super T> publicType, T instance) {
        return this.binder((Action<? super Binder>)((Action)b -> b.bind(publicType).toInstance(instance)));
    }

    default public <T> BindingsSpec bindInstance(TypeToken<? super T> publicType, T instance) {
        return this.bindInstance(GuiceUtil.toTypeLiteral(publicType), instance);
    }

    default public <T> BindingsSpec bindInstance(Class<? super T> publicType, T instance) {
        return this.bindInstance(TypeLiteral.get(publicType), instance);
    }

    default public <T> BindingsSpec multiBindInstance(Class<T> publicType, T instance) {
        return this.bindInstance(TypeLiteral.get(publicType), instance);
    }

    default public <T> BindingsSpec bindInstance(T instance) {
        Class type = (Class)Types.cast(instance.getClass());
        return this.binder((Action<? super Binder>)((Action)binder -> binder.bind(type).toInstance(instance)));
    }

    default public <T> BindingsSpec multiBindInstance(T instance) {
        return (BindingsSpec)Exceptions.uncheck(() -> {
            Class aClass = (Class)Types.cast(instance.getClass());
            return this.multiBinder(aClass, b -> b.addBinding().toInstance(instance));
        });
    }

    default public <T> BindingsSpec provider(TypeLiteral<T> publicType, Provider<? extends T> provider) {
        return this.binder((Action<? super Binder>)((Action)b -> b.bind(publicType).toProvider(provider)));
    }

    default public <T> BindingsSpec provider(TypeToken<T> publicType, Provider<? extends T> provider) {
        return this.provider(GuiceUtil.toTypeLiteral(publicType), provider);
    }

    default public <T> BindingsSpec provider(Class<T> publicType, Provider<? extends T> provider) {
        return this.provider(TypeLiteral.get(publicType), provider);
    }

    default public <T> BindingsSpec multiBindProvider(TypeLiteral<T> publicType, Provider<? extends T> provider) {
        return (BindingsSpec)Exceptions.uncheck(() -> this.multiBinder(publicType, b -> b.addBinding().toProvider(provider)));
    }

    default public <T> BindingsSpec multiBindProvider(TypeToken<T> publicType, Provider<? extends T> provider) {
        return this.multiBindProvider(GuiceUtil.toTypeLiteral(publicType), provider);
    }

    default public <T> BindingsSpec multiBindProvider(Class<T> publicType, Provider<? extends T> provider) {
        return this.multiBindProvider(TypeLiteral.get(publicType), provider);
    }

    default public <T> BindingsSpec providerType(TypeLiteral<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        return this.binder((Action<? super Binder>)((Action)binder -> binder.bind(publicType).toProvider(providerType)));
    }

    default public <T> BindingsSpec providerType(Class<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        return this.providerType(TypeLiteral.get(publicType), providerType);
    }

    default public <T> BindingsSpec providerType(TypeToken<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        return this.providerType(GuiceUtil.toTypeLiteral(publicType), providerType);
    }

    default public <T> BindingsSpec multiBindProviderType(Class<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        return (BindingsSpec)Exceptions.uncheck(() -> this.multiBinder(publicType, b -> b.addBinding().toProvider(providerType)));
    }
}

