/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Optional;
import org.reactivestreams.Publisher;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.ExecutionException;
import ratpack.exec.SuccessPromise;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.form.internal.FormParser;
import ratpack.handling.Redirector;
import ratpack.http.client.HttpClient;
import ratpack.registry.Registry;
import ratpack.render.Renderable;
import ratpack.render.Renderer;
import ratpack.server.PublicAddress;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;
import ratpack.sse.ServerSentEventStreamClient;

public class RatpackBaseRegistryModule
extends AbstractModule {
    private final Registry baseRegistry;

    public RatpackBaseRegistryModule(Registry baseRegistry) {
        this.baseRegistry = baseRegistry;
    }

    protected void configure() {
        ImmutableList simpleTypes = ImmutableList.of(ServerConfig.class, ByteBufAllocator.class, ExecController.class, MimeTypes.class, PublicAddress.class, Redirector.class, ClientErrorHandler.class, ServerErrorHandler.class, RatpackServer.class);
        ImmutableList genericTypes = ImmutableList.of((Object)new TypeToken<Renderer<Path>>(){}, (Object)new TypeToken<Renderer<SuccessPromise>>(){}, (Object)new TypeToken<Renderer<Publisher>>(){}, (Object)new TypeToken<Renderer<Renderable>>(){}, (Object)new TypeToken<Renderer<CharSequence>>(){});
        ImmutableList setTypes = ImmutableList.of(FormParser.class);
        ImmutableList optionalTypes = ImmutableList.of(FileSystemBinding.class);
        simpleTypes.stream().forEach(t -> this.simpleBind((Class)t));
        genericTypes.stream().forEach(t -> this.genericBind((TypeToken)t));
        setTypes.stream().forEach(t -> this.setBind((Class)t));
        optionalTypes.stream().forEach(t -> this.optionalBind((Class)t));
    }

    private <T> void simpleBind(Class<T> type) {
        this.bind(type).toProvider(() -> this.baseRegistry.get(type));
    }

    private <T> void genericBind(TypeToken<T> typeToken) {
        TypeLiteral typeLiteral = TypeLiteral.get((Type)typeToken.getType());
        this.bind(typeLiteral).toProvider(() -> this.baseRegistry.get(typeToken));
    }

    private <T> void setBind(Class<T> type) {
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), type);
        this.baseRegistry.getAll(type).forEach(instance -> setBinder.addBinding().toInstance(instance));
    }

    private <T> void optionalBind(Class<T> type) {
        Optional optional = this.baseRegistry.maybeGet(type);
        if (optional.isPresent()) {
            this.bind(type).toProvider(() -> this.baseRegistry.get(type));
        }
    }

    @Provides
    ExecControl execControl(ExecController execController) {
        return execController.getControl();
    }

    @Provides
    Execution execution(ExecControl execControl) {
        try {
            return execControl.getExecution();
        }
        catch (ExecutionException e) {
            throw new OutOfScopeException("Cannot provide an instance of " + Execution.class.getName() + " as none is bound to the current thread (are you outside of a managed thread?)");
        }
    }

    @Provides
    HttpClient httpClient(ExecController execController, ByteBufAllocator byteBufAllocator, ServerConfig serverConfig) {
        return HttpClient.httpClient((ExecController)execController, (ByteBufAllocator)byteBufAllocator, (int)serverConfig.getMaxContentLength());
    }

    @Provides
    ServerSentEventStreamClient sseClient(ExecController execController, ByteBufAllocator byteBufAllocator) {
        return ServerSentEventStreamClient.sseStreamClient((ExecController)execController, (ByteBufAllocator)byteBufAllocator);
    }
}

