/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.reflect.TypeToken;
import com.google.inject.Injector;
import com.google.inject.Provider;
import ratpack.guice.internal.GuiceUtil;
import ratpack.registry.RegistryBacking;

public class InjectorRegistryBacking
implements RegistryBacking {
    private final Injector injector;

    public InjectorRegistryBacking(Injector injector) {
        this.injector = injector;
    }

    public <T> Iterable<Supplier<? extends T>> provide(TypeToken<T> type) {
        return FluentIterable.from(GuiceUtil.allProvidersOfType(this.injector, type)).transform(provider -> () -> ((Provider)provider).get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InjectorRegistryBacking that = (InjectorRegistryBacking)o;
        return this.injector.equals(that.injector);
    }

    public int hashCode() {
        return this.injector.hashCode();
    }
}

