/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.Map;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.util.ExceptionUtils;

public abstract class GuiceUtil {
    private GuiceUtil() {
    }

    public static <T> void search(Injector injector, TypeToken<T> type, Function<Provider<? extends T>, Boolean> transformer) {
        Map allBindings = injector.getAllBindings();
        for (Map.Entry keyBindingEntry : allBindings.entrySet()) {
            TypeLiteral bindingType = ((Key)keyBindingEntry.getKey()).getTypeLiteral();
            if (!type.isAssignableFrom(GuiceUtil.toTypeToken(bindingType))) continue;
            Provider provider = ((Binding)keyBindingEntry.getValue()).getProvider();
            try {
                if (((Boolean)transformer.apply((Object)provider)).booleanValue()) continue;
                return;
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck((Throwable)e);
            }
        }
        Injector parent = injector.getParent();
        if (parent != null) {
            GuiceUtil.search(parent, type, transformer);
        }
    }

    public static <T> void eachOfType(Injector injector, TypeToken<T> type, final Action<? super T> action) {
        GuiceUtil.search(injector, type, new Function<Provider<? extends T>, Boolean>(){

            public Boolean apply(Provider<? extends T> from) throws Exception {
                action.execute(from.get());
                return true;
            }
        });
    }

    public static <T> void eachProviderOfType(Injector injector, TypeToken<T> type, final Action<? super Provider<? extends T>> action) {
        GuiceUtil.search(injector, type, new Function<Provider<? extends T>, Boolean>(){

            public Boolean apply(Provider<? extends T> from) throws Exception {
                action.execute(from);
                return true;
            }
        });
    }

    public static <T> ImmutableList<T> allOfType(Injector injector, TypeToken<T> type) {
        final ImmutableList.Builder listBuilder = ImmutableList.builder();
        GuiceUtil.eachOfType(injector, type, new Action<T>(){

            public void execute(T thing) throws Exception {
                listBuilder.add(thing);
            }
        });
        return listBuilder.build();
    }

    public static <T> ImmutableList<Provider<? extends T>> allProvidersOfType(Injector injector, TypeToken<T> type) {
        final ImmutableList.Builder listBuilder = ImmutableList.builder();
        GuiceUtil.eachProviderOfType(injector, type, new Action<Provider<? extends T>>(){

            public void execute(Provider<? extends T> thing) throws Exception {
                listBuilder.add(thing);
            }
        });
        return listBuilder.build();
    }

    public static <T> TypeToken<T> toTypeToken(TypeLiteral<T> type) {
        TypeToken typeToken = TypeToken.of((Type)type.getType());
        return typeToken;
    }
}

