/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.inject.AbstractModule;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provides;
import io.netty.buffer.ByteBufAllocator;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.ExecutionException;
import ratpack.http.client.HttpClient;
import ratpack.http.client.HttpClients;
import ratpack.launch.LaunchConfig;

public class DefaultRatpackModule
extends AbstractModule {
    private final LaunchConfig launchConfig;

    public DefaultRatpackModule(LaunchConfig launchConfig) {
        this.launchConfig = launchConfig;
    }

    protected void configure() {
        this.bind(LaunchConfig.class).toInstance((Object)this.launchConfig);
    }

    @Provides
    ByteBufAllocator bufferAllocator(LaunchConfig launchConfig) {
        return launchConfig.getBufferAllocator();
    }

    @Provides
    ExecController execController(LaunchConfig launchConfig) {
        return launchConfig.getExecController();
    }

    @Provides
    ExecControl execControl(ExecController execController) {
        return execController.getControl();
    }

    @Provides
    HttpClient httpClient(LaunchConfig launchConfig) {
        return HttpClients.httpClient((LaunchConfig)launchConfig);
    }

    @Provides
    Execution execution(ExecControl execControl) {
        try {
            return execControl.getExecution();
        }
        catch (ExecutionException e) {
            throw new OutOfScopeException("Cannot provide an instance of " + Execution.class.getName() + " as none is bound to the current thread (are you outside of a managed thread?)");
        }
    }
}

