/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.func.Function;
import ratpack.guice.BindingsSpec;
import ratpack.guice.Guice;
import ratpack.guice.GuiceBackedHandlerFactory;
import ratpack.guice.HandlerDecoratingModule;
import ratpack.guice.internal.DefaultBindingsSpec;
import ratpack.guice.internal.DefaultRatpackModule;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.internal.FactoryHandler;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registry;
import ratpack.reload.internal.ClassUtil;
import ratpack.reload.internal.ReloadableFileBackedFactory;

public class DefaultGuiceBackedHandlerFactory
implements GuiceBackedHandlerFactory {
    private final LaunchConfig launchConfig;

    public DefaultGuiceBackedHandlerFactory(LaunchConfig launchConfig) {
        this.launchConfig = launchConfig;
    }

    @Override
    public Handler create(Action<? super BindingsSpec> modulesAction, Function<? super Module, ? extends Injector> moduleTransformer, Function<? super Injector, ? extends Handler> injectorTransformer) throws Exception {
        File classFile;
        if (this.launchConfig.isDevelopment() && (classFile = ClassUtil.getClassFile(modulesAction)) != null) {
            ReloadableFileBackedFactory factory = new ReloadableFileBackedFactory(classFile.toPath(), true, (file, bytes) -> this.doCreate(modulesAction, moduleTransformer, injectorTransformer));
            return new FactoryHandler((Factory)factory);
        }
        return this.doCreate(modulesAction, moduleTransformer, injectorTransformer);
    }

    private Handler doCreate(Action<? super BindingsSpec> modulesAction, Function<? super Module, ? extends Injector> moduleTransformer, Function<? super Injector, ? extends Handler> injectorTransformer) throws Exception {
        LinkedList binderActions = Lists.newLinkedList();
        LinkedList injectorActions = Lists.newLinkedList();
        LinkedList modules = Lists.newLinkedList();
        DefaultBindingsSpec moduleRegistry = new DefaultBindingsSpec(this.launchConfig, binderActions, injectorActions, modules);
        this.registerDefaultModules(moduleRegistry);
        modulesAction.toConsumer().accept(moduleRegistry);
        Module overrideModule = binder -> {
            for (Action binderAction : binderActions) {
                binderAction.toConsumer().accept(binder);
            }
        };
        ImmutableList effectiveModules = ImmutableList.builder().addAll((Iterable)modules).add((Object)overrideModule).build();
        Module masterModule = (Module)effectiveModules.stream().reduce((acc, next) -> Modules.override((Module[])new Module[]{acc}).with(new Module[]{next})).get();
        Injector injector = (Injector)moduleTransformer.apply((Object)masterModule);
        for (Object initAction : injectorActions) {
            initAction.execute((Object)injector);
        }
        Handler handler = (Handler)injectorTransformer.apply((Object)injector);
        Collections.reverse(modules);
        for (Module module : modules) {
            if (!(module instanceof HandlerDecoratingModule)) continue;
            handler = ((HandlerDecoratingModule)module).decorate(injector, handler);
        }
        Registry registry = Guice.registry(injector);
        return Handlers.chain((Handler[])new Handler[]{Handlers.register((Registry)registry), handler});
    }

    protected void registerDefaultModules(BindingsSpec bindingsSpec) {
        bindingsSpec.add((Module)new DefaultRatpackModule(this.launchConfig));
    }
}

