/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice;

import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.lang.reflect.Constructor;
import javax.inject.Singleton;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.launch.LaunchConfig;
import ratpack.util.ExceptionUtils;

public abstract class ConfigurableModule<T>
extends AbstractModule {
    private Action<? super T> configurer = Action.noop();

    public void configure(Action<? super T> configurer) {
        this.configurer = configurer;
    }

    protected T createConfig(LaunchConfig launchConfig) {
        TypeToken typeToken = new TypeToken<T>(((Object)((Object)this)).getClass()){};
        if (typeToken.getType() instanceof Class) {
            Factory factory;
            Class clazz = typeToken.getRawType();
            try {
                Constructor constructor = clazz.getConstructor(LaunchConfig.class);
                factory = () -> Invokable.from((Constructor)constructor).invoke(null, new Object[]{launchConfig});
            }
            catch (NoSuchMethodException ignore) {
                try {
                    Constructor constructor = clazz.getConstructor(new Class[0]);
                    factory = () -> Invokable.from((Constructor)constructor).invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException("No suitable constructor (no arg, or just LaunchConfig) for module config type " + typeToken);
                }
            }
            return (T)ExceptionUtils.uncheck((Factory)factory);
        }
        throw new IllegalStateException("Can't auto instantiate configuration type " + typeToken + " as it is not a simple class");
    }

    protected void defaultConfig(LaunchConfig launchConfig, T config) {
    }

    @Provides
    @Singleton
    T provideConfig(LaunchConfig launchConfig) {
        T configuration = this.createConfig(launchConfig);
        this.defaultConfig(launchConfig, configuration);
        try {
            this.configurer.execute(configuration);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck((Throwable)e);
        }
        return configuration;
    }
}

