/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.List;
import java.util.function.Consumer;
import ratpack.func.Action;
import ratpack.guice.BindingsSpec;
import ratpack.guice.ConfigurableModule;
import ratpack.guice.NoSuchModuleException;
import ratpack.launch.LaunchConfig;

class DefaultBindingsSpec
implements BindingsSpec {
    private final List<Module> modules;
    private final LaunchConfig launchConfig;
    private final List<Action<? super Binder>> binderActions;
    private final List<Action<? super Injector>> injectorActions;

    public DefaultBindingsSpec(LaunchConfig launchConfig, List<Action<? super Binder>> binderActions, List<Action<? super Injector>> injectorActions, List<Module> modules) {
        this.launchConfig = launchConfig;
        this.binderActions = binderActions;
        this.injectorActions = injectorActions;
        this.modules = modules;
    }

    @Override
    public LaunchConfig getLaunchConfig() {
        return this.launchConfig;
    }

    @Override
    public BindingsSpec bind(Class<?> type) {
        return this.binder((Action<? super Binder>)((Action)binder -> binder.bind(type)));
    }

    @Override
    public <T> BindingsSpec bind(Class<T> publicType, Class<? extends T> implType) {
        return this.binder((Action<? super Binder>)((Action)binder -> binder.bind(publicType).to(implType)));
    }

    @Override
    public <T> BindingsSpec bindInstance(Class<? super T> publicType, T instance) {
        return this.binder((Action<? super Binder>)((Action)binder -> binder.bind(publicType).toInstance(instance)));
    }

    @Override
    public <T> BindingsSpec bindInstance(T instance) {
        Class<?> type = instance.getClass();
        return this.binder((Action<? super Binder>)((Action)binder -> binder.bind(type).toInstance(instance)));
    }

    @Override
    public <T> BindingsSpec providerType(Class<T> publicType, Class<? extends Provider<? extends T>> providerType) {
        return this.binder((Action<? super Binder>)((Action)binder -> binder.bind(publicType).toProvider(providerType)));
    }

    @Override
    public <T> BindingsSpec provider(Class<T> publicType, Provider<? extends T> provider) {
        return this.binder((Action<? super Binder>)((Action)b -> b.bind(publicType).toProvider(provider)));
    }

    @Override
    public BindingsSpec add(Module module) {
        this.modules.add(module);
        return this;
    }

    @Override
    public BindingsSpec add(Class<? extends Module> moduleClass) {
        return this.add(this.createModule(moduleClass));
    }

    private <T extends Module> T createModule(Class<T> clazz) {
        try {
            return (T)((Module)clazz.newInstance());
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Module " + clazz.getName() + " is not reflectively instantiable", e);
        }
    }

    @Override
    public <C, T extends ConfigurableModule<C>> BindingsSpec add(Class<T> moduleClass, Action<? super C> configuration) {
        ConfigurableModule t = (ConfigurableModule)((Object)this.createModule(moduleClass));
        t.configure(configuration);
        this.modules.add((Module)t);
        return this;
    }

    @Override
    public <T extends Module> BindingsSpec config(Class<T> moduleClass, Consumer<? super T> configurer) throws NoSuchModuleException {
        this.modules.stream().filter(moduleClass::isInstance).map(moduleClass::cast).forEach(configurer);
        return this;
    }

    @Override
    public BindingsSpec binder(Action<? super Binder> action) {
        this.binderActions.add(action);
        return this;
    }

    @Override
    public BindingsSpec init(Action<? super Injector> action) {
        this.injectorActions.add(action);
        return this;
    }

    @Override
    public BindingsSpec init(Class<? extends Runnable> clazz) {
        this.injectorActions.add((Action<? super Injector>)((Action)injector -> ((Runnable)injector.getInstance(clazz)).run()));
        return this;
    }
}

