/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.guice.BindingsSpec;
import ratpack.guice.internal.DefaultGuiceBackedHandlerFactory;
import ratpack.guice.internal.InjectorRegistryBacking;
import ratpack.guice.internal.JustInTimeInjectorRegistry;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBacking;

public abstract class Guice {
    private Guice() {
    }

    public static Builder builder(final LaunchConfig launchConfig) {
        return new Builder(){
            private Injector parent;
            private Action<? super BindingsSpec> bindings = Action.noop();

            @Override
            public Builder parent(Injector injector) {
                this.parent = injector;
                return this;
            }

            @Override
            public Builder bindings(Action<? super BindingsSpec> action) {
                this.bindings = action;
                return this;
            }

            @Override
            public Handler build(Action<? super Chain> action) throws Exception {
                Function moduleTransformer = this.parent == null ? Guice.newInjectorFactory(launchConfig) : Guice.childInjectorFactory(this.parent);
                return new DefaultGuiceBackedHandlerFactory(launchConfig).create(this.bindings, (Function<? super Module, ? extends Injector>)moduleTransformer, (Function<? super Injector, ? extends Handler>)((Function)injector -> Handlers.chain((LaunchConfig)launchConfig, (Registry)Guice.justInTimeRegistry(injector), (Action)action)));
            }
        };
    }

    public static Registry justInTimeRegistry(Injector injector) {
        return new JustInTimeInjectorRegistry(injector);
    }

    public static Registry registry(Injector injector) {
        return Registries.backedRegistry((RegistryBacking)new InjectorRegistryBacking(injector));
    }

    public static Function<Module, Injector> newInjectorFactory(LaunchConfig launchConfig) {
        Stage stage = launchConfig.isDevelopment() ? Stage.DEVELOPMENT : Stage.PRODUCTION;
        return from -> from == null ? com.google.inject.Guice.createInjector((Stage)stage, (Module[])new Module[0]) : com.google.inject.Guice.createInjector((Stage)stage, (Module[])new Module[]{from});
    }

    private static Function<Module, Injector> childInjectorFactory(Injector parent) {
        return from -> from == null ? parent.createChildInjector(new Module[0]) : parent.createChildInjector(new Module[]{from});
    }

    public static interface Builder {
        public Builder parent(Injector var1);

        public Builder bindings(Action<? super BindingsSpec> var1);

        public Handler build(Action<? super Chain> var1) throws Exception;
    }
}

