/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gson.internal;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import ratpack.core.handling.Context;
import ratpack.core.http.internal.HttpHeaderConstants;
import ratpack.core.render.Renderer;
import ratpack.core.render.RendererSupport;
import ratpack.func.Types;
import ratpack.gson.GsonRender;

public class GsonRenderer
extends RendererSupport<GsonRender> {
    public static final TypeToken<Renderer<GsonRender>> TYPE = Types.intern((TypeToken)new TypeToken<Renderer<GsonRender>>(){});
    public static final Renderer<GsonRender> INSTANCE = new GsonRenderer();

    public void render(Context ctx, GsonRender object) throws Exception {
        Gson gson = object.getGson();
        if (gson == null) {
            gson = ctx.maybeGet(Gson.class).orElseGet(() -> new GsonBuilder().create());
        }
        ByteBuf buffer = ((ByteBufAllocator)ctx.get(ByteBufAllocator.class)).buffer();
        ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream);
        try {
            gson.toJson(object.getObject(), (Appendable)writer);
            ((Writer)writer).flush();
        }
        catch (JsonIOException e) {
            buffer.release();
            ctx.error((Throwable)e);
            return;
        }
        ctx.getResponse().contentTypeIfNotSet(HttpHeaderConstants.JSON).send(buffer);
    }
}

