/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gson.internal;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import ratpack.core.handling.Context;
import ratpack.core.http.TypedData;
import ratpack.core.parse.Parse;
import ratpack.core.parse.Parser;
import ratpack.core.parse.ParserSupport;
import ratpack.func.Nullable;
import ratpack.func.Types;
import ratpack.gson.GsonParseOpts;
import ratpack.gson.internal.DefaultGsonParseOpts;

public class GsonParser
extends ParserSupport<GsonParseOpts> {
    public static final TypeToken<Parser<GsonParseOpts>> TYPE = Types.intern((TypeToken)new TypeToken<Parser<GsonParseOpts>>(){});
    public static final Parser<GsonParseOpts> INSTANCE = new GsonParser();

    private GsonParser() {
    }

    @Nullable
    public <T> T parse(Context context, TypedData body, Parse<T, GsonParseOpts> parse) throws Exception {
        if (!body.getContentType().isJson()) {
            return null;
        }
        GsonParseOpts opts = parse.getOpts().orElse(DefaultGsonParseOpts.INSTANCE);
        TypeToken type = parse.getType();
        Gson gson = opts.getGson().orElseGet(() -> (Gson)context.get(Gson.class));
        InputStream inputStream = body.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        return (T)gson.fromJson((Reader)bufferedReader, type.getType());
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (parses 'application/json' and types ending in '+json')";
    }
}

