/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gson;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import ratpack.core.http.ResponseChunks;
import ratpack.core.http.internal.HttpHeaderConstants;
import ratpack.core.parse.Parse;
import ratpack.exec.registry.Registry;
import ratpack.exec.stream.Streams;
import ratpack.exec.stream.WriteStream;
import ratpack.func.Function;
import ratpack.func.Nullable;
import ratpack.gson.GsonParseOpts;
import ratpack.gson.GsonRender;
import ratpack.gson.internal.DefaultGsonParseOpts;
import ratpack.gson.internal.DefaultGsonRender;

public abstract class Gson {
    private Gson() {
    }

    public static GsonRender json(Object object) {
        return new DefaultGsonRender(object, null);
    }

    public static GsonRender json(Object object, @Nullable com.google.gson.Gson gson) {
        return new DefaultGsonRender(object, gson);
    }

    public static Parse<JsonElement, GsonParseOpts> jsonElement() {
        return Gson.jsonElement(null);
    }

    public static Parse<JsonElement, GsonParseOpts> jsonElement(@Nullable com.google.gson.Gson gson) {
        return Gson.fromJson(JsonElement.class, gson);
    }

    public static <T> Parse<T, GsonParseOpts> fromJson(Class<T> type) {
        return Gson.fromJson(type, null);
    }

    public static <T> Parse<T, GsonParseOpts> fromJson(TypeToken<T> type) {
        return Gson.fromJson(type, null);
    }

    public static <T> Parse<T, GsonParseOpts> fromJson(Class<T> type, @Nullable com.google.gson.Gson gson) {
        return Parse.of(type, (Object)new DefaultGsonParseOpts(gson));
    }

    public static <T> Parse<T, GsonParseOpts> fromJson(TypeToken<T> type, @Nullable com.google.gson.Gson gson) {
        return Parse.of(type, (Object)new DefaultGsonParseOpts(gson));
    }

    public static <T> ResponseChunks chunkedJsonList(Registry registry, Publisher<T> stream) {
        return Gson.chunkedJsonList((com.google.gson.Gson)registry.get(com.google.gson.Gson.class), stream);
    }

    public static <T> ResponseChunks chunkedJsonList(final com.google.gson.Gson gson, Publisher<T> stream) {
        return ResponseChunks.bufferChunks((CharSequence)HttpHeaderConstants.JSON, (Publisher)Streams.streamMap(stream, (s, out) -> {
            final JsonWriter writer = gson.newJsonWriter(new Writer(){

                @Override
                public void write(char[] b, int off, int len) throws IOException {
                    out.item((Object)Unpooled.copiedBuffer((char[])b, (int)off, (int)len, (Charset)Charset.defaultCharset()));
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            });
            writer.beginArray();
            return new WriteStream<T>(){

                public void item(T item) {
                    try {
                        gson.toJson(item, item.getClass(), writer);
                    }
                    catch (Exception e) {
                        s.cancel();
                        out.error((Throwable)e);
                    }
                }

                public void error(Throwable throwable) {
                    out.error(throwable);
                }

                public void complete() {
                    try {
                        writer.endArray();
                        writer.close();
                        out.complete();
                    }
                    catch (IOException e) {
                        out.error((Throwable)e);
                    }
                }
            };
        }));
    }

    public static <T> Function<T, String> toJson(Registry registry) {
        return obj -> ((com.google.gson.Gson)registry.get(com.google.gson.Gson.class)).toJson(obj);
    }
}

