/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle.internal;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.tasks.JavaExec;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.internal.Factory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.process.internal.JavaExecHandleBuilder;
import ratpack.gradle.GradleVersion;
import ratpack.gradle.continuous.RatpackDeploymentHandle;
import ratpack.gradle.continuous.run.DefaultRatpackAdapter;
import ratpack.gradle.continuous.run.DefaultSignal;
import ratpack.gradle.continuous.run.RatpackAdapter;
import ratpack.gradle.continuous.run.RatpackSpec;
import ratpack.gradle.continuous.run.RatpackWorkerServer;
import ratpack.gradle.continuous.run.Signal;
import ratpack.gradle.internal.Invoker;

public class RatpackContinuousRunAction
implements Action<Task> {
    private static final GradleVersion V2_13 = GradleVersion.version("2.13");
    private static final GradleVersion V2_14 = GradleVersion.version("2.14");
    private static final GradleVersion V4_2 = GradleVersion.version("4.2");
    private static final String FLATTEN_CLASSLOADERS = "ratpack.flattenClassloaders";
    private final GradleVersion gradleVersion;
    private final String absoluteRootDirPath;
    private final Supplier<ServiceRegistry> serviceRegistrySupplier;

    public RatpackContinuousRunAction(String gradleVersion, String absoluteRootDirPath, Supplier<ServiceRegistry> serviceRegistrySupplier) {
        this.serviceRegistrySupplier = serviceRegistrySupplier;
        this.gradleVersion = GradleVersion.version(gradleVersion);
        this.absoluteRootDirPath = absoluteRootDirPath;
    }

    public void execute(Task untyped) {
        JavaExec task = (JavaExec)untyped;
        ServiceRegistry services = this.serviceRegistrySupplier.get();
        String deploymentId = task.getPath();
        DeploymentRegistry deploymentRegistry = (DeploymentRegistry)services.get(DeploymentRegistry.class);
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> deploymentHandleClass = RatpackContinuousRunAction.loadClass(loader, "org.gradle.deployment.internal.DeploymentHandle");
        if (this.gradleVersion.compareTo(V4_2) < 0) {
            RatpackAdapter deploymentHandle = (RatpackAdapter)Invoker.of(DeploymentRegistry.class, "get", Class.class, deploymentHandleClass).invoke(deploymentRegistry, deploymentHandleClass, deploymentId);
            if (deploymentHandle == null) {
                RatpackAdapter proxy = (RatpackAdapter)Proxy.newProxyInstance(loader, new Class[]{deploymentHandleClass, RatpackAdapter.class}, (InvocationHandler)new ProxyBacking(this.createAdapter(task, services)));
                Invoker.of(DeploymentRegistry.class, "register", String.class, Object.class).invoke(deploymentRegistry, deploymentId, proxy);
                proxy.start();
            } else {
                deploymentHandle.reload();
            }
        } else {
            RatpackDeploymentHandle deploymentHandle = (RatpackDeploymentHandle)deploymentRegistry.get(deploymentId, RatpackDeploymentHandle.class);
            if (deploymentHandle == null) {
                deploymentRegistry.start(deploymentId, DeploymentRegistry.ChangeBehavior.NONE, RatpackDeploymentHandle.class, new Object[]{this.createAdapter(task, services)});
            } else {
                deploymentHandle.reload();
            }
        }
    }

    private static Class<?> loadClass(ClassLoader loader, String name) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private Object getWorkerProcessBuilderFactory(ServiceRegistry services) {
        Type type = this.gradleVersion.compareTo(V2_13) < 0 ? new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Class[]{RatpackContinuousRunAction.loadClass(this.getClass().getClassLoader(), "org.gradle.process.internal.WorkerProcessBuilder")};
            }

            @Override
            public Type getRawType() {
                return Factory.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        } : (this.gradleVersion.compareTo(V2_14) < 0 ? RatpackContinuousRunAction.loadClass(this.getClass().getClassLoader(), "org.gradle.process.internal.WorkerProcessFactory") : RatpackContinuousRunAction.loadClass(this.getClass().getClassLoader(), "org.gradle.process.internal.worker.WorkerProcessFactory"));
        return services.get(type);
    }

    private RatpackAdapter createAdapter(JavaExec task, ServiceRegistry services) {
        Object builder;
        if (this.gradleVersion.compareTo(V2_13) < 0) {
            builder = Invoker.invokeParamless(Factory.class, this.getWorkerProcessBuilderFactory(services), "create");
            Invoker.of("org.gradle.process.internal.worker.WorkerProcessBuilder", "worker", Action.class).invoke(builder, this.createServer(task));
        } else {
            Class<?> factoryClass = this.gradleVersion.compareTo(V2_14) < 0 ? RatpackContinuousRunAction.loadClass(this.getClass().getClassLoader(), "org.gradle.process.internal.WorkerProcessFactory") : RatpackContinuousRunAction.loadClass(this.getClass().getClassLoader(), "org.gradle.process.internal.worker.WorkerProcessFactory");
            builder = Invoker.of(factoryClass, "create", Action.class).invoke(this.getWorkerProcessBuilderFactory(services), this.createServer(task));
        }
        Class<?> workerProcessBuilderClass = RatpackContinuousRunAction.loadClass(this.getClass().getClassLoader(), "org.gradle.process.internal.worker.WorkerProcessBuilder");
        this.configureWorkerProcessBuilder(workerProcessBuilderClass, builder, task);
        Object process = Invoker.invokeParamless(workerProcessBuilderClass, builder, "build");
        Invoker.invokeParamless("org.gradle.process.internal.worker.WorkerProcess", process, "start");
        Object connection = Invoker.invokeParamless("org.gradle.process.internal.worker.WorkerProcess", process, "getConnection");
        final RatpackAdapter adapter = (RatpackAdapter)Invoker.of("org.gradle.internal.remote.ObjectConnection", "addOutgoing", Class.class).invoke(connection, RatpackAdapter.class);
        final DefaultSignal signal = new DefaultSignal();
        Invoker.of("org.gradle.internal.remote.ObjectConnection", "addIncoming", Class.class, Object.class).invoke(connection, Signal.class, signal);
        Invoker.invokeParamless("org.gradle.internal.remote.ObjectConnection", connection, "connect");
        return new RatpackAdapter(){

            @Override
            public void start() {
                adapter.start();
                signal.await();
            }

            @Override
            public void reload() {
                adapter.reload();
                signal.await();
            }

            @Override
            public void buildError(Throwable throwable) {
                adapter.buildError(throwable);
                signal.await();
            }

            @Override
            public boolean isRunning() {
                boolean running = adapter.isRunning();
                signal.await();
                return running;
            }

            @Override
            public void stop() {
                adapter.stop();
            }
        };
    }

    private void configureWorkerProcessBuilder(Class<?> clazz, Object builder, JavaExec task) {
        Invoker.of(clazz, "setBaseName", String.class).invoke(builder, "Gradle Ratpack Worker");
        Invoker.of(clazz, "sharedPackages", String[].class).invoke(builder, new Object[]{new String[]{"ratpack.gradle.continuous.run"}});
        JavaExecHandleBuilder javaCommand = (JavaExecHandleBuilder)Invoker.invokeParamless(clazz, builder, "getJavaCommand");
        javaCommand.setWorkingDir(task.getWorkingDir());
        javaCommand.setEnvironment(task.getEnvironment());
        javaCommand.setJvmArgs(task.getJvmArgs());
        javaCommand.setSystemProperties(task.getSystemProperties());
        javaCommand.setMinHeapSize(task.getMinHeapSize());
        javaCommand.setMaxHeapSize(task.getMaxHeapSize());
        javaCommand.setBootstrapClasspath(task.getBootstrapClasspath());
        javaCommand.setEnableAssertions(task.getEnableAssertions());
        javaCommand.setDebug(task.getDebug());
    }

    private RatpackWorkerServer createServer(JavaExec task) {
        return new RatpackWorkerServer(new DefaultRatpackAdapter(this.createRatpackSpec(task)));
    }

    private RatpackSpec createRatpackSpec(JavaExec task) {
        Set classpath = task.getClasspath().getFiles();
        ArrayList<URL> changing = new ArrayList<URL>();
        ArrayList<URL> nonChanging = new ArrayList<URL>();
        boolean flattenClassloaders = task.getExtensions().getExtraProperties().has(FLATTEN_CLASSLOADERS);
        for (File file : classpath) {
            if (flattenClassloaders || file.isDirectory() || file.getAbsolutePath().startsWith(this.absoluteRootDirPath)) {
                changing.add(RatpackContinuousRunAction.toUrl(file));
                continue;
            }
            nonChanging.add(RatpackContinuousRunAction.toUrl(file));
        }
        List args = task.getArgs();
        return new RatpackSpec(nonChanging.toArray(new URL[0]), changing.toArray(new URL[0]), (String)task.getMainClass().get(), args.toArray(new String[0]));
    }

    private static URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class ProxyBacking
    implements InvocationHandler {
        private final RatpackAdapter delegate;

        public ProxyBacking(RatpackAdapter delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            switch (method.getName()) {
                case "isRunning": {
                    return this.delegate.isRunning();
                }
                case "start": {
                    this.delegate.start();
                    break;
                }
                case "reload": {
                    this.delegate.reload();
                    break;
                }
                case "stop": {
                    this.delegate.stop();
                }
            }
            return null;
        }
    }
}

