/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle.continuous.run;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import ratpack.gradle.continuous.run.RatpackAdapter;
import ratpack.gradle.continuous.run.Signal;
import ratpack.gradle.internal.Invoker;

public class RatpackWorkerServer
implements Action<Object>,
RatpackAdapter,
Serializable {
    private final RatpackAdapter runAdapter;
    private CountDownLatch latch;
    private Signal signal;

    public RatpackWorkerServer(RatpackAdapter runAdapter) {
        this.runAdapter = runAdapter;
    }

    public void execute(Object context) {
        RatpackWorkerServer.disableUrlConnectionCaching();
        Object serverConnection = Invoker.invokeParamless("org.gradle.process.internal.worker.WorkerProcessContext", context, "getServerConnection");
        Invoker.of("org.gradle.internal.remote.ObjectConnection", "addIncoming", Class.class, Object.class).invoke(serverConnection, RatpackAdapter.class, this);
        this.signal = (Signal)Invoker.of("org.gradle.internal.remote.ObjectConnection", "addOutgoing", Class.class).invoke(serverConnection, Signal.class);
        Invoker.invokeParamless("org.gradle.internal.remote.ObjectConnection", serverConnection, "connect");
        this.latch = new CountDownLatch(1);
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        this.runAdapter.start();
        this.signal.fire();
    }

    @Override
    public void reload() {
        this.runAdapter.reload();
        this.signal.fire();
    }

    @Override
    public boolean isRunning() {
        return this.runAdapter.isRunning();
    }

    @Override
    public void stop() {
        this.latch.countDown();
        this.runAdapter.stop();
    }

    @Override
    public void buildError(Throwable throwable) {
        this.runAdapter.buildError(throwable);
        this.signal.fire();
    }

    private static void disableUrlConnectionCaching() {
        try {
            URL url = new URL("jar:file://valid_jar_url_syntax.jar!/");
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

