/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle.continuous.run;

import java.io.Closeable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import ratpack.gradle.internal.Invoker;

public class RatpackServerProxy {
    public static final String CAPTURER_CLASS_NAME = "ratpack.core.server.internal.ServerCapturer";
    public static final String BLOCK_CLASS_NAME = "ratpack.func.Block";
    public static final String SERVER_INTERFACE_NAME = "ratpack.core.server.RatpackServer";
    private final Object server;
    private final ClassLoader classLoader;

    public RatpackServerProxy(Object server, ClassLoader classLoader) {
        this.server = server;
        this.classLoader = classLoader;
    }

    public void stop() {
        try {
            Invoker.invokeParamless(this.classLoader.loadClass(SERVER_INTERFACE_NAME), this.server, "stop");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to stop server", e);
        }
    }

    public static RatpackServerProxy capture(ClassLoader classLoader, String mainClassName, String[] appArgs) {
        Method captureWithMethod;
        Class<?> capturer = RatpackServerProxy.loadClass(classLoader, CAPTURER_CLASS_NAME);
        Class<?> serverType = RatpackServerProxy.loadClass(classLoader, SERVER_INTERFACE_NAME);
        AtomicReference serverOrErrorRef = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        try {
            captureWithMethod = capturer.getMethod("captureWith", Consumer.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find capture() on ServerCapturer", e);
        }
        Consumer<Object> consumer = server -> {
            if (serverType.isAssignableFrom(server.getClass())) {
                serverOrErrorRef.compareAndSet(null, server);
            } else {
                serverOrErrorRef.compareAndSet(null, new RuntimeException("Captured " + server.getClass().getName() + ", not a " + SERVER_INTERFACE_NAME));
            }
            latch.countDown();
        };
        new Thread(() -> {
            try {
                Object capturerReleaser;
                try {
                    capturerReleaser = captureWithMethod.invoke(null, consumer);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke get() on ServerCapturer", e);
                }
                try {
                    RatpackServerProxy.findMainMethod(classLoader, mainClassName).invoke(null, new Object[]{appArgs});
                }
                catch (Exception e) {
                    throw new RuntimeException("failed to invoke main(String...) on class: " + mainClassName, e);
                }
                finally {
                    if (capturerReleaser instanceof Closeable) {
                        ((Closeable)capturerReleaser).close();
                    }
                }
            }
            catch (Throwable t) {
                serverOrErrorRef.compareAndSet(null, t);
                latch.countDown();
            }
        }, "ratpack-starter").start();
        int waitSecs = 30;
        try {
            if (latch.await(30L, TimeUnit.SECONDS)) {
                return RatpackServerProxy.toServerProxy(classLoader, serverOrErrorRef.get());
            }
            throw new IllegalStateException("Start did not create server or fail within " + waitSecs + " seconds");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private static RatpackServerProxy toServerProxy(ClassLoader classLoader, Object serverOrError) {
        if (serverOrError instanceof Throwable) {
            if (serverOrError instanceof Error) {
                throw (Error)serverOrError;
            }
            if (serverOrError instanceof RuntimeException) {
                throw (RuntimeException)serverOrError;
            }
            throw new RuntimeException((Throwable)serverOrError);
        }
        return new RatpackServerProxy(serverOrError, classLoader);
    }

    private static Method findMainMethod(ClassLoader classLoader, String mainClassName) {
        Method main;
        Class<?> mainClass;
        try {
            mainClass = classLoader.loadClass(mainClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Did not find specified main class: " + mainClassName, e);
        }
        try {
            main = mainClass.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Did not find main(String...) method on main class: " + mainClassName, e);
        }
        if (!Modifier.isStatic(main.getModifiers())) {
            throw new RuntimeException("main(String...) is not static on class: " + mainClassName);
        }
        return main;
    }

    private static Class<?> loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not load " + className, e);
        }
    }

    public boolean isRunning() {
        try {
            return (Boolean)this.server.getClass().getMethod("isRunning", new Class[0]).invoke(this.server, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke isRunning on server", e);
        }
    }
}

