/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.application.CreateStartScripts;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.tasks.Jar;
import ratpack.gradle.GradleVersion;
import ratpack.gradle.RatpackBasePlugin;
import ratpack.gradle.RatpackExtension;
import ratpack.gradle.internal.Invoker;
import ratpack.gradle.internal.IoUtil;
import ratpack.gradle.internal.RatpackContinuousRunAction;
import ratpack.gradle.internal.ServiceRegistrySupplier;

public class RatpackPlugin
implements Plugin<Project> {
    private static final GradleVersion GRADLE_VERSION_BASELINE = GradleVersion.version("2.6");
    private static final GradleVersion GRADLE_5 = GradleVersion.version("5.0");
    private static final GradleVersion GRADLE_6 = GradleVersion.version("6.0");
    private static final GradleVersion GRADLE_7_1 = GradleVersion.version("7.1");

    public void apply(Project project) {
        Supplier<String> jarNameSupplier;
        Task run;
        GradleVersion gradleVersion = GradleVersion.version(project.getGradle().getGradleVersion());
        if (gradleVersion.compareTo(GRADLE_VERSION_BASELINE) < 0) {
            throw new GradleException("Ratpack requires Gradle version ${GRADLE_VERSION_BASELINE.version} or later");
        }
        project.getPlugins().apply(ApplicationPlugin.class);
        project.getPlugins().apply(RatpackBasePlugin.class);
        RatpackExtension ratpackExtension = (RatpackExtension)project.getExtensions().getByType(RatpackExtension.class);
        SourceSetContainer sourceSets = RatpackPlugin.getSourceSets(project, gradleVersion);
        SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
        mainSourceSet.getResources().srcDir(ratpackExtension::getBaseDir);
        if (project.getGradle().getStartParameter().isContinuous()) {
            Supplier<ServiceRegistry> serviceRegistrySupplier;
            run = project.getTasks().getByName("run");
            if (gradleVersion.compareTo(GRADLE_5) < 0) {
                ServiceRegistry services = ((ProjectInternal)project).getServices();
                serviceRegistrySupplier = () -> services;
            } else {
                serviceRegistrySupplier = new ServiceRegistrySupplier(project.getObjects());
            }
            run.setActions(Collections.singletonList(new RatpackContinuousRunAction(project.getGradle().getGradleVersion(), project.getRootDir().getAbsolutePath(), serviceRegistrySupplier)));
        }
        run = (JavaExec)project.getTasks().getByName("run");
        run.systemProperty("ratpack.development", (Object)"true");
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration implementation = Optional.ofNullable((Configuration)configurationContainer.findByName("implementation")).orElseGet(() -> configurationContainer.getByName("compile"));
        implementation.getDependencies().add((Object)ratpackExtension.getCore());
        Configuration testImplementation = Optional.ofNullable((Configuration)configurationContainer.findByName("testImplementation")).orElseGet(() -> configurationContainer.getByName("testCompile"));
        testImplementation.getDependencies().add((Object)ratpackExtension.getTest());
        Jar jarTask = (Jar)project.getTasks().getByName("jar");
        Distribution mainDistribution = (Distribution)((DistributionContainer)project.getExtensions().getByType(DistributionContainer.class)).getByName("main");
        final SourceSetOutput mainSourceSetOutput = mainSourceSet.getOutput();
        if (gradleVersion.compareTo(GRADLE_6) < 0) {
            jarNameSupplier = this.getDeprecatedArchiveName(jarTask);
        } else {
            final Property archiveFileName = jarTask.getArchiveFileName();
            jarNameSupplier = new Supplier<String>(){

                @Override
                public String get() {
                    return (String)archiveFileName.get();
                }
            };
        }
        mainDistribution.contents((Action)new Action<CopySpec>(){

            public void execute(CopySpec copySpec) {
                String jarName = (String)jarNameSupplier.get();
                copySpec.from((Object)mainSourceSetOutput, (Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.into((Object)"app");
                    }
                });
                copySpec.eachFile(fileCopyDetails -> {
                    if (fileCopyDetails.getName().equals(jarName)) {
                        fileCopyDetails.exclude();
                    }
                });
            }
        });
        project.getTasks().getByName("startScripts").doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                CreateStartScripts startScripts = (CreateStartScripts)task;
                String jarName = (String)jarNameSupplier.get();
                IoUtil.setText(startScripts.getUnixScript(), IoUtil.getText(startScripts.getUnixScript()).replaceAll("CLASSPATH=(\")?(.+)(\")?\n", "CLASSPATH=$1\\$APP_HOME/app:$2$3\ncd \"\\$APP_HOME/app\"\n").replace(":$APP_HOME/lib/" + jarName, ""));
                IoUtil.setText(startScripts.getWindowsScript(), IoUtil.getText(startScripts.getWindowsScript()).replaceAll("set CLASSPATH=?(.+)\r\n", "set CLASSPATH=%APP_HOME%/app;$1\r\ncd \"%APP_HOME%/app\"\r\n").replace(":%APP_HOME%/lib/" + jarName, ""));
            }
        });
    }

    private static SourceSetContainer getSourceSets(Project project, GradleVersion gradleVersion) {
        if (gradleVersion.compareTo(GRADLE_7_1) < 0) {
            return ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        }
        return (SourceSetContainer)Invoker.invokeParamless(JavaPluginExtension.class, project.getExtensions().getByType(JavaPluginExtension.class), "getSourceSets");
    }

    private Supplier<String> getDeprecatedArchiveName(Jar jarTask) {
        return () -> ((Jar)jarTask).getArchiveName();
    }
}

