/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Invoker {
    private final Method method;

    public Invoker(Method method) {
        this.method = method;
    }

    public static Object invokeParamless(String type, Object instance, String methodName) {
        return Invoker.invokeParamless(Invoker.loadClass(type), instance, methodName);
    }

    public static Object invokeParamless(Class<?> type, Object instance, String methodName) {
        return Invoker.of(type, methodName, new Class[0]).invoke(instance, new Object[0]);
    }

    public static Invoker of(String type, String methodName, Class<?> ... types) {
        return Invoker.of(Invoker.loadClass(type), methodName, types);
    }

    public static Invoker of(Class<?> type, String methodName, Class<?> ... types) {
        try {
            return new Invoker(type.getMethod(methodName, types));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Object invoke(Object instance, Object ... args) {
        try {
            return this.method.invoke(instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> loadClass(String name) {
        try {
            return Invoker.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

