/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle;

import java.io.File;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import ratpack.gradle.internal.IoUtil;

public class RatpackExtension {
    public static final String GROUP = "io.ratpack";
    private final DependencyHandler dependencies;
    private File baseDir;
    public static final CompletableFuture<String> VERSION_FUTURE = new CompletableFuture();

    public RatpackExtension(Project project) {
        this.dependencies = project.getDependencies();
        this.baseDir = project.file((Object)"src/ratpack");
    }

    public Dependency getCore() {
        return this.dependency("core");
    }

    public Dependency getGroovy() {
        return this.dependency("groovy");
    }

    public Dependency getTest() {
        return this.dependency("test");
    }

    public Dependency getGroovyTest() {
        return this.dependency("groovy-test");
    }

    public Dependency dependency(String name) {
        return this.dependencies.create((Object)("io.ratpack:ratpack-" + name + ":" + this.getVersion()));
    }

    private String getVersion() {
        try {
            return VERSION_FUTURE.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    static {
        new Thread(() -> {
            try {
                URL resource = RatpackExtension.class.getClassLoader().getResource("ratpack/ratpack-version.txt");
                VERSION_FUTURE.complete(IoUtil.getText(resource).trim());
            }
            catch (Throwable e) {
                VERSION_FUTURE.completeExceptionally(e);
            }
        }).start();
    }
}

