/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle.continuous.run;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.process.internal.WorkerProcessContext;
import ratpack.gradle.continuous.run.RatpackAdapter;
import ratpack.gradle.continuous.run.Signal;

public class RatpackWorkerServer
implements Action<WorkerProcessContext>,
RatpackAdapter,
Serializable {
    private final RatpackAdapter runAdapter;
    private CountDownLatch latch;
    private Signal signal;

    public RatpackWorkerServer(RatpackAdapter runAdapter) {
        this.runAdapter = runAdapter;
    }

    public void execute(WorkerProcessContext context) {
        this.disableUrlConnectionCaching();
        context.getServerConnection().addIncoming(RatpackAdapter.class, (Object)this);
        this.signal = (Signal)context.getServerConnection().addOutgoing(Signal.class);
        context.getServerConnection().connect();
        try {
            this.latch = new CountDownLatch(1);
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void start() {
        this.runAdapter.start();
        this.signal.fire();
    }

    @Override
    public void reload() {
        this.runAdapter.reload();
        this.signal.fire();
    }

    @Override
    public boolean isRunning() {
        return this.runAdapter.isRunning();
    }

    @Override
    public void stop() {
        this.latch.countDown();
        this.runAdapter.stop();
    }

    @Override
    public void buildError(Throwable throwable) {
        this.runAdapter.buildError(throwable);
        this.signal.fire();
    }

    private void disableUrlConnectionCaching() {
        try {
            URL url = new URL("jar:file://valid_jar_url_syntax.jar!/");
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
        }
        catch (MalformedURLException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

