/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle.continuous.run;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLClassLoader;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import ratpack.gradle.continuous.run.RatpackAdapter;
import ratpack.gradle.continuous.run.RatpackServerProxy;
import ratpack.gradle.continuous.run.RatpackSpec;

public class DefaultRatpackAdapter
implements RatpackAdapter,
Serializable {
    private static final Logger LOGGER = Logging.getLogger(RatpackAdapter.class);
    private final RatpackSpec spec;
    private boolean started;
    private ClassLoader baseLoader;
    private ClassLoader appLoader;
    private RatpackServerProxy server;

    public DefaultRatpackAdapter(RatpackSpec spec) {
        this.spec = spec;
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        this.started = true;
        this.baseLoader = new URLClassLoader(this.spec.getClasspath(), null);
        this.reload();
    }

    @Override
    public void reload() {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.appLoader != null && this.appLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.appLoader)).close();
            }
            catch (IOException e) {
                LOGGER.warn("failed to close old classloader", (Throwable)e);
            }
        }
        this.appLoader = new URLClassLoader(this.spec.getChangingClasspath(), this.baseLoader);
        Thread.currentThread().setContextClassLoader(this.appLoader);
        this.server = RatpackServerProxy.capture(this.appLoader, this.spec.getMainClass(), this.spec.getArgs());
    }

    @Override
    public void buildError(Throwable throwable) {
    }

    @Override
    public boolean isRunning() {
        return this.server != null && this.server.isRunning();
    }

    @Override
    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

