/*
 * Decompiled with CFR 0.152.
 */
package ratpack.gradle.continuous;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import org.gradle.deployment.internal.DeploymentHandle;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.internal.Factory;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;
import ratpack.gradle.continuous.RatpackDeploymentHandle;
import ratpack.gradle.continuous.run.DefaultRatpackAdapter;
import ratpack.gradle.continuous.run.DefaultSignal;
import ratpack.gradle.continuous.run.RatpackAdapter;
import ratpack.gradle.continuous.run.RatpackSpec;
import ratpack.gradle.continuous.run.RatpackWorkerServer;
import ratpack.gradle.continuous.run.Signal;

public class RatpackContinuousRun
extends JavaExec {
    public boolean flattenClassloaders;

    @TaskAction
    public void exec() {
        String deploymentId = this.getPath();
        DeploymentRegistry deploymentRegistry = this.getDeploymentRegistry();
        RatpackDeploymentHandle deploymentHandle = (RatpackDeploymentHandle)deploymentRegistry.get(RatpackDeploymentHandle.class, deploymentId);
        if (deploymentHandle == null) {
            deploymentHandle = new RatpackDeploymentHandle(this.createAdapter());
            deploymentRegistry.register(deploymentId, (DeploymentHandle)deploymentHandle);
            deploymentHandle.start();
        } else {
            deploymentHandle.reload();
        }
    }

    @Inject
    protected DeploymentRegistry getDeploymentRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Factory<WorkerProcessBuilder> getWorkerProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    private RatpackAdapter createAdapter() {
        WorkerProcessBuilder builder = (WorkerProcessBuilder)this.getWorkerProcessBuilderFactory().create();
        builder.setBaseName("Gradle Ratpack Worker");
        builder.sharedPackages(new String[]{"ratpack.gradle.continuous.run"});
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir((Object)this.getWorkingDir());
        javaCommand.setEnvironment(this.getEnvironment());
        javaCommand.setJvmArgs((Iterable)this.getJvmArgs());
        javaCommand.setSystemProperties(this.getSystemProperties());
        javaCommand.setMinHeapSize(this.getMinHeapSize());
        javaCommand.setMaxHeapSize(this.getMaxHeapSize());
        javaCommand.setBootstrapClasspath(this.getBootstrapClasspath());
        javaCommand.setEnableAssertions(this.getEnableAssertions());
        javaCommand.setDebug(this.getDebug());
        WorkerProcess process = builder.worker((Action)new RatpackWorkerServer(new DefaultRatpackAdapter(this.createRatpackSpec()))).build();
        process.start();
        final RatpackAdapter adapter = (RatpackAdapter)process.getConnection().addOutgoing(RatpackAdapter.class);
        final DefaultSignal signal = new DefaultSignal();
        process.getConnection().addIncoming(Signal.class, (Object)signal);
        process.getConnection().connect();
        return new RatpackAdapter(){

            @Override
            public void start() {
                adapter.start();
                signal.await();
            }

            @Override
            public void reload() {
                adapter.reload();
                signal.await();
            }

            @Override
            public void buildError(Throwable throwable) {
                adapter.buildError(throwable);
                signal.await();
            }

            @Override
            public boolean isRunning() {
                boolean running = adapter.isRunning();
                signal.await();
                return running;
            }

            @Override
            public void stop() {
                adapter.stop();
            }
        };
    }

    private RatpackSpec createRatpackSpec() {
        Set classpath = this.getClasspath().getFiles();
        ArrayList<URL> changing = new ArrayList<URL>();
        ArrayList<URL> nonChanging = new ArrayList<URL>();
        String absoluteRootDirPath = this.getProject().getRootDir().getAbsolutePath();
        for (File file : classpath) {
            if (this.flattenClassloaders || file.isDirectory() || file.getAbsolutePath().startsWith(absoluteRootDirPath)) {
                changing.add(this.toUrl(file));
                continue;
            }
            nonChanging.add(this.toUrl(file));
        }
        List args = this.getArgs();
        return new RatpackSpec(nonChanging.toArray(new URL[nonChanging.size()]), changing.toArray(new URL[changing.size()]), this.getMain(), args.toArray(new String[args.size()]));
    }

    private URL toUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

