/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import javax.inject.Inject;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.dropwizard.metrics.Slf4jConfig;
import ratpack.dropwizard.metrics.internal.AbstractReporterProvider;
import ratpack.dropwizard.metrics.internal.RegexMetricFilter;

public class Slf4jReporterProvider
extends AbstractReporterProvider<Slf4jReporter, Slf4jConfig> {
    @Inject
    public Slf4jReporterProvider(MetricRegistry metricRegistry, DropwizardMetricsConfig config) {
        super(metricRegistry, config, DropwizardMetricsConfig::getSlf4j);
    }

    @Override
    protected Slf4jReporter build(Slf4jConfig slf4j) {
        Slf4jReporter.Builder builder = Slf4jReporter.forRegistry((MetricRegistry)this.metricRegistry);
        if (slf4j.getLogLevel() != null) {
            builder.withLoggingLevel(slf4j.getLogLevel());
        }
        if (slf4j.getIncludeFilter() != null || slf4j.getExcludeFilter() != null) {
            builder.filter((MetricFilter)new RegexMetricFilter(slf4j.getIncludeFilter(), slf4j.getExcludeFilter()));
        }
        if (slf4j.getMarker() != null) {
            builder.markWith(slf4j.getMarker());
        }
        if (slf4j.getPrefix() != null) {
            builder.prefixedWith(slf4j.getPrefix());
        }
        if (slf4j.getLogger() != null) {
            builder.outputTo(slf4j.getLogger());
        }
        if (slf4j.getRateUnit() != null) {
            builder.convertRatesTo(slf4j.getRateUnit());
        }
        if (slf4j.getDurationUnit() != null) {
            builder.convertDurationsTo(slf4j.getDurationUnit());
        }
        return builder.build();
    }
}

