/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import javax.inject.Inject;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.dropwizard.metrics.JmxConfig;
import ratpack.dropwizard.metrics.internal.AbstractReporterProvider;
import ratpack.dropwizard.metrics.internal.RegexMetricFilter;

public class JmxReporterProvider
extends AbstractReporterProvider<JmxReporter, JmxConfig> {
    @Inject
    public JmxReporterProvider(MetricRegistry metricRegistry, DropwizardMetricsConfig config) {
        super(metricRegistry, config, DropwizardMetricsConfig::getJmx);
    }

    @Override
    protected JmxReporter build(JmxConfig jmx) {
        JmxReporter.Builder builder = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry);
        if (jmx.getIncludeFilter() != null || jmx.getExcludeFilter() != null) {
            builder.filter((MetricFilter)new RegexMetricFilter(jmx.getIncludeFilter(), jmx.getExcludeFilter()));
        }
        return builder.build();
    }
}

