/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import ratpack.core.http.client.HttpClient;
import ratpack.core.http.client.internal.DefaultHttpClient;
import ratpack.core.http.client.internal.HttpClientStats;
import ratpack.core.service.Service;
import ratpack.core.service.StartEvent;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.exec.ExecController;

@Singleton
public class HttpClientMetrics
implements Service,
Runnable {
    private static final String METRIC_PREFIX = "httpclient.";
    private static final String TOTAL_ACTIVE_CONNECTIONS = HttpClientMetrics.getMetricName("total.active.connections");
    private static final String TOTAL_IDLE_CONNECTIONS = HttpClientMetrics.getMetricName("total.idle.connections");
    private static final String TOTAL_CONNECTIONS = HttpClientMetrics.getMetricName("total.connections");
    private final HttpClient httpClient;
    private final MetricRegistry metricRegistry;
    private final DropwizardMetricsConfig config;
    private final ConcurrentMap<String, HttpMetricGauge> gauges;

    @Inject
    public HttpClientMetrics(HttpClient httpClient, MetricRegistry metricRegistry, DropwizardMetricsConfig config) {
        this.httpClient = httpClient;
        this.metricRegistry = metricRegistry;
        this.config = config;
        this.gauges = new ConcurrentHashMap<String, HttpMetricGauge>();
    }

    public void onStart(StartEvent event) throws Exception {
        this.config.getHttpClient().ifPresent(httpClientConfig -> {
            boolean enabled = httpClientConfig.isEnabled();
            int pollingFrequency = httpClientConfig.getPollingFrequencyInSeconds();
            if (enabled && this.httpClient instanceof DefaultHttpClient) {
                ExecController execController = (ExecController)event.getRegistry().get(ExecController.class);
                execController.getExecutor().scheduleAtFixedRate(this, 0L, pollingFrequency, TimeUnit.SECONDS);
            }
        });
    }

    @Override
    public void run() {
        HttpClientStats httpClientStats = ((DefaultHttpClient)this.httpClient).getHttpClientStats();
        this.gauge(TOTAL_ACTIVE_CONNECTIONS).setValue(httpClientStats.getTotalActiveConnectionCount());
        this.gauge(TOTAL_IDLE_CONNECTIONS).setValue(httpClientStats.getTotalIdleConnectionCount());
        this.gauge(TOTAL_CONNECTIONS).setValue(httpClientStats.getTotalConnectionCount());
        httpClientStats.getStatsPerHost().forEach((host, stats) -> {
            this.gauge(HttpClientMetrics.getHostMetricName(host, "total.active.connections")).setValue(stats.getActiveConnectionCount());
            this.gauge(HttpClientMetrics.getHostMetricName(host, "total.idle.connections")).setValue(stats.getIdleConnectionCount());
            this.gauge(HttpClientMetrics.getHostMetricName(host, "total.connections")).setValue(stats.getTotalConnectionCount());
        });
    }

    private HttpMetricGauge gauge(String name) {
        if (this.gauges.containsKey(name)) {
            return (HttpMetricGauge)this.gauges.get(name);
        }
        try {
            HttpMetricGauge gauge = (HttpMetricGauge)this.metricRegistry.register(name, (Metric)new HttpMetricGauge());
            this.gauges.put(name, gauge);
            return gauge;
        }
        catch (IllegalArgumentException e) {
            HttpMetricGauge gauge = (HttpMetricGauge)this.gauges.get(name);
            if (gauge != null && this.metricRegistry.getNames().contains(name)) {
                return gauge;
            }
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
    }

    private static String getMetricName(String name) {
        return METRIC_PREFIX + name;
    }

    private static String getHostMetricName(String host, String name) {
        return HttpClientMetrics.getMetricName(host + "." + name);
    }

    private static class HttpMetricGauge
    implements Gauge<Long> {
        private AtomicLong value = new AtomicLong(0L);

        private HttpMetricGauge() {
        }

        public Long getValue() {
            return this.value.longValue();
        }

        public void setValue(Long val) {
            this.value.set(val);
        }
    }
}

