/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.GraphiteReporter;
import javax.inject.Inject;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.dropwizard.metrics.GraphiteConfig;
import ratpack.dropwizard.metrics.internal.AbstractReporterProvider;
import ratpack.dropwizard.metrics.internal.RegexMetricFilter;

public class GraphiteReporterProvider
extends AbstractReporterProvider<GraphiteReporter, GraphiteConfig> {
    @Inject
    public GraphiteReporterProvider(MetricRegistry metricRegistry, DropwizardMetricsConfig config) {
        super(metricRegistry, config, DropwizardMetricsConfig::getGraphite);
    }

    @Override
    protected GraphiteReporter build(GraphiteConfig graphite) {
        GraphiteReporter.Builder builder = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry);
        if (graphite.getIncludeFilter() != null || graphite.getExcludeFilter() != null) {
            builder.filter((MetricFilter)new RegexMetricFilter(graphite.getIncludeFilter(), graphite.getExcludeFilter()));
        }
        if (graphite.getPrefix() != null) {
            builder.prefixedWith(graphite.getPrefix());
        }
        if (graphite.getDurationUnit() != null) {
            builder.convertDurationsTo(graphite.getDurationUnit());
        }
        if (graphite.getRateUnit() != null) {
            builder.convertRatesTo(graphite.getRateUnit());
        }
        return builder.build(graphite.getSender());
    }
}

