/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.Optional;
import ratpack.core.http.Request;
import ratpack.dropwizard.metrics.BlockingExecTimingInterceptor;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.func.Block;

public class DefaultBlockingExecTimingInterceptor
implements BlockingExecTimingInterceptor {
    private MetricRegistry metricRegistry;
    private DropwizardMetricsConfig config;

    public DefaultBlockingExecTimingInterceptor(MetricRegistry metricRegistry, DropwizardMetricsConfig config) {
        this.metricRegistry = metricRegistry;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(Execution execution, ExecInterceptor.ExecType type, Block executionSegment) throws Exception {
        Optional requestOpt;
        if (type == ExecInterceptor.ExecType.BLOCKING && (requestOpt = execution.maybeGet(Request.class)).isPresent()) {
            Request request = (Request)requestOpt.get();
            String tag = this.buildBlockingTimerTag(request.getPath(), request.getMethod().getName());
            Timer.Context timer = this.metricRegistry.timer(tag).time();
            try {
                executionSegment.execute();
            }
            finally {
                timer.stop();
            }
            return;
        }
        executionSegment.execute();
    }

    private String buildBlockingTimerTag(String requestPath, String requestMethod) {
        String tagName;
        String string = tagName = requestPath.equals("") ? "root" : requestPath.replace("/", ".");
        if (this.config.getRequestMetricGroups() != null) {
            for (Map.Entry<String, String> metricGrouping : this.config.getRequestMetricGroups().entrySet()) {
                if (!requestPath.matches(metricGrouping.getValue())) continue;
                tagName = metricGrouping.getKey();
                break;
            }
        }
        return tagName + "." + requestMethod.toLowerCase() + "-blocking";
    }
}

