/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import javax.inject.Inject;
import ratpack.dropwizard.metrics.CsvConfig;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.dropwizard.metrics.internal.AbstractReporterProvider;
import ratpack.dropwizard.metrics.internal.RegexMetricFilter;

public class CsvReporterProvider
extends AbstractReporterProvider<CsvReporter, CsvConfig> {
    @Inject
    public CsvReporterProvider(MetricRegistry metricRegistry, DropwizardMetricsConfig config) {
        super(metricRegistry, config, DropwizardMetricsConfig::getCsv);
    }

    @Override
    protected CsvReporter build(CsvConfig csv) {
        CsvReporter.Builder builder = CsvReporter.forRegistry((MetricRegistry)this.metricRegistry);
        if (csv.getIncludeFilter() != null || csv.getExcludeFilter() != null) {
            builder.filter((MetricFilter)new RegexMetricFilter(csv.getIncludeFilter(), csv.getExcludeFilter()));
        }
        return builder.build(csv.getReportDirectory());
    }
}

