/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import javax.inject.Inject;
import javax.inject.Provider;
import ratpack.dropwizard.metrics.BlockingExecTimingInterceptor;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.dropwizard.metrics.internal.DefaultBlockingExecTimingInterceptor;

public class BlockingExecTimingInterceptorProvider
implements Provider<BlockingExecTimingInterceptor> {
    private final MetricRegistry metricRegistry;
    private final DropwizardMetricsConfig config;
    private static final BlockingExecTimingInterceptor NOOP = (execution, execType, executionSegment) -> executionSegment.execute();

    @Inject
    public BlockingExecTimingInterceptorProvider(MetricRegistry metricRegistry, DropwizardMetricsConfig config) {
        this.metricRegistry = metricRegistry;
        this.config = config;
    }

    public BlockingExecTimingInterceptor get() {
        return this.config.isBlockingTimingMetrics() ? new DefaultBlockingExecTimingInterceptor(this.metricRegistry, this.config) : NOOP;
    }
}

