/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.google.inject.Provider;
import java.util.Optional;
import java.util.function.Function;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.dropwizard.metrics.ReporterConfigSupport;

public abstract class AbstractReporterProvider<T extends Reporter, C extends ReporterConfigSupport<C>>
implements Provider<T> {
    protected final MetricRegistry metricRegistry;
    protected final DropwizardMetricsConfig config;
    protected final Function<DropwizardMetricsConfig, Optional<C>> configFactory;

    public AbstractReporterProvider(MetricRegistry metricRegistry, DropwizardMetricsConfig config, Function<DropwizardMetricsConfig, Optional<C>> configFactory) {
        this.metricRegistry = metricRegistry;
        this.config = config;
        this.configFactory = configFactory;
    }

    protected abstract T build(C var1);

    public T get() {
        return (T)((Reporter)this.configFactory.apply(this.config).map(c -> {
            if (c.isEnabled()) {
                return this.build(c);
            }
            return null;
        }).orElse(null));
    }
}

