/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolSubpageMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PooledByteBufAllocatorMetricSet
implements MetricSet {
    private final PooledByteBufAllocator pooledByteBufAllocator;
    private final boolean includeArenas;
    private final Map<String, Metric> metrics;

    public PooledByteBufAllocatorMetricSet(PooledByteBufAllocator pooledByteBufAllocator) {
        this(pooledByteBufAllocator, false);
    }

    public PooledByteBufAllocatorMetricSet(PooledByteBufAllocator pooledByteBufAllocator, boolean includeArenas) {
        this.pooledByteBufAllocator = pooledByteBufAllocator;
        this.includeArenas = includeArenas;
        this.metrics = new HashMap<String, Metric>();
        this.initMetrics();
    }

    private void initMetrics() {
        PooledByteBufAllocatorMetric metric = this.pooledByteBufAllocator.metric();
        this.metrics.put("numDirectArenas", (Metric)((Gauge)() -> metric.numDirectArenas()));
        this.metrics.put("numHeapArenas", (Metric)((Gauge)() -> metric.numHeapArenas()));
        this.metrics.put("numThreadLocalCaches", (Metric)((Gauge)() -> metric.numThreadLocalCaches()));
        this.metrics.put("smallCacheSize", (Metric)((Gauge)() -> metric.smallCacheSize()));
        this.metrics.put("tinyCacheSize", (Metric)((Gauge)() -> metric.tinyCacheSize()));
        this.metrics.put("normalCacheSize", (Metric)((Gauge)() -> metric.normalCacheSize()));
        this.metrics.put("chunkSize", (Metric)((Gauge)() -> metric.chunkSize()));
        this.metrics.put("usedDirectMemory", (Metric)((Gauge)() -> metric.usedDirectMemory()));
        this.metrics.put("usedHeapMemory", (Metric)((Gauge)() -> metric.usedHeapMemory()));
        if (this.includeArenas) {
            Iterator<PoolArenaMetric> directArenasIterator = metric.directArenas().iterator();
            this.initPoolArenaMetrics(directArenasIterator);
            Iterator<PoolArenaMetric> heapArenasIterator = metric.heapArenas().iterator();
            this.initPoolArenaMetrics(heapArenasIterator);
        }
    }

    private void initPoolArenaMetrics(Iterator<PoolArenaMetric> poolArenasIterator) {
        int counter = 0;
        while (poolArenasIterator.hasNext()) {
            PoolArenaMetric poolArenaMetric = poolArenasIterator.next();
            String prefix = String.format("poolArena.%s", counter);
            this.metrics.put(String.format("%s.activeAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numActiveAllocations()));
            this.metrics.put(String.format("%s.numActiveBytes", prefix), (Metric)((Gauge)() -> poolArenaMetric.numActiveBytes()));
            this.metrics.put(String.format("%s.numActiveHugeAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numActiveHugeAllocations()));
            this.metrics.put(String.format("%s.numActiveNormalAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numActiveNormalAllocations()));
            this.metrics.put(String.format("%s.numActiveSmallAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numActiveSmallAllocations()));
            this.metrics.put(String.format("%s.numActiveTinyAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numActiveTinyAllocations()));
            this.metrics.put(String.format("%s.numAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numAllocations()));
            this.metrics.put(String.format("%s.numDeallocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numDeallocations()));
            this.metrics.put(String.format("%s.numHugeAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numHugeAllocations()));
            this.metrics.put(String.format("%s.numHugeDeallocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numHugeDeallocations()));
            this.metrics.put(String.format("%s.numNormalAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numNormalAllocations()));
            this.metrics.put(String.format("%s.numNormalDeallocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numNormalDeallocations()));
            this.metrics.put(String.format("%s.numSmallAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numSmallAllocations()));
            this.metrics.put(String.format("%s.numSmallDeallocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numSmallDeallocations()));
            this.metrics.put(String.format("%s.numTinyAllocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numTinyAllocations()));
            this.metrics.put(String.format("%s.numTinyDeallocations", prefix), (Metric)((Gauge)() -> poolArenaMetric.numTinyDeallocations()));
            this.metrics.put(String.format("%s.numSmallSubpages", prefix), (Metric)((Gauge)() -> poolArenaMetric.numSmallSubpages()));
            this.metrics.put(String.format("%s.numTinySubpages", prefix), (Metric)((Gauge)() -> poolArenaMetric.numTinySubpages()));
            Iterator<PoolChunkListMetric> chunksIterator = poolArenaMetric.chunkLists().iterator();
            this.initPoolChunkListMetrics(prefix, chunksIterator);
            Iterator<PoolSubpageMetric> smallSubpagesIterator = poolArenaMetric.smallSubpages().iterator();
            this.initSubpageMetrics(prefix, "smallSubpage", smallSubpagesIterator);
            Iterator<PoolSubpageMetric> tinySubpagesIterator = poolArenaMetric.tinySubpages().iterator();
            this.initSubpageMetrics(prefix, "tinySubpage", tinySubpagesIterator);
            ++counter;
        }
    }

    private void initPoolChunkListMetrics(String prefix, Iterator<PoolChunkListMetric> chunksIterator) {
        int counter = 0;
        while (chunksIterator.hasNext()) {
            PoolChunkListMetric poolChunkMetrics = chunksIterator.next();
            String poolChunkPrefix = String.format("poolChunkList.%s", counter);
            this.metrics.put(String.format("%s.%s.maxUsage", prefix, poolChunkPrefix), (Metric)((Gauge)() -> poolChunkMetrics.maxUsage()));
            this.metrics.put(String.format("%s.%s.minUsage", prefix, poolChunkPrefix), (Metric)((Gauge)() -> poolChunkMetrics.minUsage()));
            ++counter;
        }
    }

    private void initSubpageMetrics(String prefix, String subpageName, Iterator<PoolSubpageMetric> subpagesIterator) {
        int counter = 0;
        while (subpagesIterator.hasNext()) {
            PoolSubpageMetric poolSubpageMetric = subpagesIterator.next();
            String subpagePrefix = String.format("%s.%s", subpageName, counter);
            this.metrics.put(String.format("%s.%s.elementSize", prefix, subpagePrefix), (Metric)((Gauge)() -> poolSubpageMetric.elementSize()));
            this.metrics.put(String.format("%s.%s.maxNumElements", prefix, subpagePrefix), (Metric)((Gauge)() -> poolSubpageMetric.maxNumElements()));
            this.metrics.put(String.format("%s.%s.numAvailable", prefix, subpagePrefix), (Metric)((Gauge)() -> poolSubpageMetric.numAvailable()));
            this.metrics.put(String.format("%s.%s.pageSize", prefix, subpagePrefix), (Metric)((Gauge)() -> poolSubpageMetric.pageSize()));
            ++counter;
        }
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }
}

