/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics;

import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import ratpack.dropwizard.metrics.ByteBufAllocatorConfig;
import ratpack.dropwizard.metrics.ConsoleConfig;
import ratpack.dropwizard.metrics.CsvConfig;
import ratpack.dropwizard.metrics.GraphiteConfig;
import ratpack.dropwizard.metrics.HttpClientConfig;
import ratpack.dropwizard.metrics.JmxConfig;
import ratpack.dropwizard.metrics.Slf4jConfig;
import ratpack.dropwizard.metrics.WebsocketConfig;
import ratpack.func.Action;
import ratpack.util.Exceptions;

public class DropwizardMetricsConfig {
    public static final Duration DEFAULT_INTERVAL = Duration.ofSeconds(30L);
    private boolean jvmMetrics;
    private boolean prometheusCollection;
    private boolean requestTimingMetrics = true;
    private boolean blockingTimingMetrics = true;
    private Map<String, String> requestMetricGroups;
    private Optional<JmxConfig> jmx = Optional.empty();
    private Optional<ConsoleConfig> console = Optional.empty();
    private Optional<WebsocketConfig> webSocket = Optional.empty();
    private Optional<CsvConfig> csv = Optional.empty();
    private Optional<Slf4jConfig> slf4j = Optional.empty();
    private Optional<GraphiteConfig> graphite = Optional.empty();
    private Optional<ByteBufAllocatorConfig> byteBufAllocator = Optional.empty();
    private Optional<HttpClientConfig> httpClient = Optional.empty();

    public boolean isJvmMetrics() {
        return this.jvmMetrics;
    }

    public DropwizardMetricsConfig jvmMetrics(boolean jvmMetrics) {
        this.jvmMetrics = jvmMetrics;
        return this;
    }

    public boolean isPrometheusCollection() {
        return this.prometheusCollection;
    }

    public DropwizardMetricsConfig prometheusCollection(boolean prometheusCollection) {
        this.prometheusCollection = prometheusCollection;
        return this;
    }

    public Optional<ByteBufAllocatorConfig> getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    public DropwizardMetricsConfig byteBufAllocator() {
        return this.byteBufAllocator((Action<? super ByteBufAllocatorConfig>)Action.noop());
    }

    public DropwizardMetricsConfig byteBufAllocator(Action<? super ByteBufAllocatorConfig> configure) {
        try {
            configure.execute((Object)this.byteBufAllocator.orElseGet(() -> {
                this.byteBufAllocator = Optional.of(new ByteBufAllocatorConfig());
                return this.byteBufAllocator.get();
            }));
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public boolean isRequestTimingMetrics() {
        return this.requestTimingMetrics;
    }

    public DropwizardMetricsConfig requestTimingMetrics(boolean requestTimingMetrics) {
        this.requestTimingMetrics = requestTimingMetrics;
        return this;
    }

    public boolean isBlockingTimingMetrics() {
        return this.blockingTimingMetrics;
    }

    public DropwizardMetricsConfig blockingTimingMetrics(boolean blockingTimingMetrics) {
        this.blockingTimingMetrics = blockingTimingMetrics;
        return this;
    }

    public Map<String, String> getRequestMetricGroups() {
        return this.requestMetricGroups;
    }

    public DropwizardMetricsConfig requestMetricGroups(Map<String, String> requestMetricGroups) {
        this.requestMetricGroups = requestMetricGroups;
        return this;
    }

    public Optional<JmxConfig> getJmx() {
        return this.jmx;
    }

    public DropwizardMetricsConfig jmx() {
        return this.jmx((Action<? super JmxConfig>)Action.noop());
    }

    public DropwizardMetricsConfig jmx(Action<? super JmxConfig> configure) {
        try {
            configure.execute((Object)this.jmx.orElseGet(() -> {
                this.jmx = Optional.of(new JmxConfig());
                return this.jmx.get();
            }));
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Optional<ConsoleConfig> getConsole() {
        return this.console;
    }

    public DropwizardMetricsConfig console() {
        return this.console((Action<? super ConsoleConfig>)Action.noop());
    }

    public DropwizardMetricsConfig console(Action<? super ConsoleConfig> configure) {
        try {
            configure.execute((Object)this.console.orElseGet(() -> {
                this.console = Optional.of(new ConsoleConfig());
                return this.console.get();
            }));
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Optional<Slf4jConfig> getSlf4j() {
        return this.slf4j;
    }

    public DropwizardMetricsConfig slf4j() {
        return this.slf4j((Action<? super Slf4jConfig>)Action.noop());
    }

    public DropwizardMetricsConfig slf4j(Action<? super Slf4jConfig> configure) {
        try {
            configure.execute((Object)this.slf4j.orElseGet(() -> {
                this.slf4j = Optional.of(new Slf4jConfig());
                return this.slf4j.get();
            }));
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Optional<WebsocketConfig> getWebSocket() {
        return this.webSocket;
    }

    public DropwizardMetricsConfig webSocket() {
        return this.webSocket((Action<? super WebsocketConfig>)Action.noop());
    }

    public DropwizardMetricsConfig webSocket(Action<? super WebsocketConfig> configure) {
        try {
            configure.execute((Object)this.webSocket.orElseGet(() -> {
                this.webSocket = Optional.of(new WebsocketConfig());
                return this.webSocket.get();
            }));
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Optional<CsvConfig> getCsv() {
        return this.csv;
    }

    public DropwizardMetricsConfig csv(Action<? super CsvConfig> configure) {
        try {
            configure.execute((Object)this.csv.orElseGet(() -> {
                this.csv = Optional.of(new CsvConfig());
                return this.csv.get();
            }));
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Optional<GraphiteConfig> getGraphite() {
        return this.graphite;
    }

    public DropwizardMetricsConfig graphite(Action<? super GraphiteConfig> configure) {
        try {
            configure.execute((Object)this.graphite.orElseGet(() -> {
                this.graphite = Optional.of(new GraphiteConfig());
                return this.graphite.get();
            }));
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }

    public Optional<HttpClientConfig> getHttpClient() {
        return this.httpClient;
    }

    public DropwizardMetricsConfig httpClient() {
        return this.httpClient((Action<? super HttpClientConfig>)Action.noop());
    }

    public DropwizardMetricsConfig httpClient(Action<? super HttpClientConfig> configure) {
        try {
            configure.execute((Object)this.httpClient.orElseGet(() -> {
                this.httpClient = Optional.of(new HttpClientConfig());
                return this.httpClient.get();
            }));
            return this;
        }
        catch (Exception e) {
            throw Exceptions.uncheck((Throwable)e);
        }
    }
}

