/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import ratpack.dropwizard.metrics.BlockingExecTimingInterceptor;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.dropwizard.metrics.RequestTimingHandler;
import ratpack.dropwizard.metrics.internal.BlockingExecTimingInterceptorProvider;
import ratpack.dropwizard.metrics.internal.ConsoleReporterProvider;
import ratpack.dropwizard.metrics.internal.CsvReporterProvider;
import ratpack.dropwizard.metrics.internal.GaugeTypeListener;
import ratpack.dropwizard.metrics.internal.GraphiteReporterProvider;
import ratpack.dropwizard.metrics.internal.JmxReporterProvider;
import ratpack.dropwizard.metrics.internal.MeteredMethodInterceptor;
import ratpack.dropwizard.metrics.internal.MetricRegistryPeriodicPublisher;
import ratpack.dropwizard.metrics.internal.MetricsBroadcaster;
import ratpack.dropwizard.metrics.internal.RequestTimingHandlerProvider;
import ratpack.dropwizard.metrics.internal.Slf4jReporterProvider;
import ratpack.dropwizard.metrics.internal.TimedMethodInterceptor;
import ratpack.guice.ConfigurableModule;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.service.Service;
import ratpack.service.StartEvent;
import ratpack.service.StopEvent;

public class DropwizardMetricsModule
extends ConfigurableModule<DropwizardMetricsConfig> {
    public static final String RATPACK_METRIC_REGISTRY = "ratpack-metrics";

    protected void configure() {
        SharedMetricRegistries.remove((String)RATPACK_METRIC_REGISTRY);
        MetricRegistry metricRegistry = SharedMetricRegistries.getOrCreate((String)RATPACK_METRIC_REGISTRY);
        this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Metered.class), new MethodInterceptor[]{this.injected(new MeteredMethodInterceptor())});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Timed.class), new MethodInterceptor[]{this.injected(new TimedMethodInterceptor())});
        this.bindListener(Matchers.any(), this.injected(new GaugeTypeListener()));
        this.bind(JmxReporter.class).toProvider(JmxReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(ConsoleReporter.class).toProvider(ConsoleReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(Slf4jReporter.class).toProvider(Slf4jReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(CsvReporter.class).toProvider(CsvReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(GraphiteReporter.class).toProvider(GraphiteReporterProvider.class).in(Scopes.SINGLETON);
        this.bind(MetricRegistryPeriodicPublisher.class).in(Scopes.SINGLETON);
        this.bind(MetricsBroadcaster.class).in(Scopes.SINGLETON);
        this.bind(Startup.class);
        this.bind(BlockingExecTimingInterceptor.class).toProvider(BlockingExecTimingInterceptorProvider.class).in(Scopes.SINGLETON);
        this.bind(RequestTimingHandler.class).toProvider(RequestTimingHandlerProvider.class).in(Scopes.SINGLETON);
        Provider handlerProvider = this.getProvider(RequestTimingHandler.class);
        Multibinder.newSetBinder((Binder)this.binder(), HandlerDecorator.class).addBinding().toProvider(() -> HandlerDecorator.prepend((Handler)((Handler)handlerProvider.get())));
    }

    private <T> T injected(T instance) {
        this.requestInjection(instance);
        return instance;
    }

    private static class Startup
    implements Service {
        private final DropwizardMetricsConfig config;
        private final Injector injector;

        @Inject
        public Startup(DropwizardMetricsConfig config, Injector injector) {
            this.config = config;
            this.injector = injector;
        }

        public void onStart(StartEvent event) throws Exception {
            this.config.getJmx().ifPresent(jmx -> {
                if (jmx.isEnabled()) {
                    ((JmxReporter)this.injector.getInstance(JmxReporter.class)).start();
                }
            });
            this.config.getConsole().ifPresent(console -> {
                if (console.isEnabled()) {
                    ((ConsoleReporter)this.injector.getInstance(ConsoleReporter.class)).start(console.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            this.config.getSlf4j().ifPresent(slf4j -> {
                if (slf4j.isEnabled()) {
                    ((Slf4jReporter)this.injector.getInstance(Slf4jReporter.class)).start(slf4j.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            this.config.getCsv().ifPresent(csv -> {
                if (csv.isEnabled()) {
                    ((CsvReporter)this.injector.getInstance(CsvReporter.class)).start(csv.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            this.config.getGraphite().ifPresent(graphite -> {
                if (graphite.isEnabled()) {
                    ((GraphiteReporter)this.injector.getInstance(GraphiteReporter.class)).start(graphite.getReporterInterval().getSeconds(), TimeUnit.SECONDS);
                }
            });
            if (this.config.isJvmMetrics()) {
                MetricRegistry metricRegistry = (MetricRegistry)this.injector.getInstance(MetricRegistry.class);
                metricRegistry.registerAll((MetricSet)new GarbageCollectorMetricSet());
                metricRegistry.registerAll((MetricSet)new ThreadStatesGaugeSet());
                metricRegistry.registerAll((MetricSet)new MemoryUsageGaugeSet());
            }
        }

        public void onStop(StopEvent event) throws Exception {
            Iterable scheduledReporters = event.getRegistry().getAll(ScheduledReporter.class);
            for (ScheduledReporter scheduledReporter : scheduledReporters) {
                if (scheduledReporter == null) continue;
                scheduledReporter.stop();
            }
        }
    }
}

