/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import ratpack.exec.Promise;

public class TimedMethodInterceptor
implements MethodInterceptor {
    @Inject
    MetricRegistry metricRegistry;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result;
        String timerTag = this.buildTimerTag(invocation.getMethod().getAnnotation(Timed.class), invocation.getMethod());
        Timer timer = this.metricRegistry.timer(timerTag);
        Timer.Context timerContext = timer.time();
        try {
            result = invocation.proceed();
            if (result instanceof Promise) {
                result = ((Promise)result).time(duration -> timer.update((long)duration.getNano(), TimeUnit.NANOSECONDS));
            } else {
                timerContext.stop();
            }
        }
        catch (Exception e) {
            timerContext.stop();
            throw e;
        }
        return result;
    }

    private String buildTimerTag(Timed annotation, Method method) {
        if (annotation.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName()});
        }
        if (annotation.absolute()) {
            return annotation.name();
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{annotation.name()});
    }
}

