/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import java.lang.reflect.Method;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TimedMethodInterceptor
implements MethodInterceptor {
    @Inject
    MetricRegistry metricRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String timerTag = this.buildTimerTag(invocation.getMethod().getAnnotation(Timed.class), invocation.getMethod());
        Timer.Context timer = this.metricRegistry.timer(timerTag).time();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            timer.stop();
        }
    }

    private String buildTimerTag(Timed annotation, Method method) {
        if (annotation.name().isEmpty()) {
            return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{method.getName()});
        }
        if (annotation.absolute()) {
            return annotation.name();
        }
        return MetricRegistry.name(method.getDeclaringClass(), (String[])new String[]{annotation.name()});
    }
}

