/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.handling.Context;
import ratpack.handling.Handler;

@Singleton
public class RequestTimingHandler
implements Handler {
    private final MetricRegistry metricRegistry;
    private final DropwizardMetricsConfig config;

    @Inject
    public RequestTimingHandler(MetricRegistry metricRegistry, DropwizardMetricsConfig config) {
        this.metricRegistry = metricRegistry;
        this.config = config;
    }

    public void handle(Context context) throws Exception {
        context.onClose(outcome -> {
            String timerName = this.buildRequestTimerTag(outcome.getRequest().getPath(), outcome.getRequest().getMethod().getName());
            String responseCodeCounter = String.valueOf(outcome.getResponse().getStatus().getCode()).substring(0, 1) + "xx-responses";
            this.metricRegistry.timer(timerName).update((long)outcome.getDuration().getNano(), TimeUnit.NANOSECONDS);
            this.metricRegistry.counter(responseCodeCounter).inc();
        });
        context.next();
    }

    private String buildRequestTimerTag(String requestPath, String requestMethod) {
        String tagName;
        String string = tagName = requestPath.equals("") ? "root" : requestPath.replace("/", ".");
        if (this.config.getRequestMetricGroups() != null) {
            for (Map.Entry<String, String> metricGrouping : this.config.getRequestMetricGroups().entrySet()) {
                if (!requestPath.matches(metricGrouping.getValue())) continue;
                tagName = metricGrouping.getKey();
                break;
            }
        }
        return tagName + "." + requestMethod.toLowerCase() + "-requests";
    }
}

