/*
 * Decompiled with CFR 0.152.
 */
package ratpack.dropwizard.metrics;

import com.codahale.metrics.MetricFilter;
import io.netty.buffer.ByteBufAllocator;
import org.reactivestreams.Publisher;
import ratpack.dropwizard.metrics.DropwizardMetricsConfig;
import ratpack.dropwizard.metrics.internal.MetricRegistryJsonMapper;
import ratpack.dropwizard.metrics.internal.MetricsBroadcaster;
import ratpack.dropwizard.metrics.internal.RegexMetricFilter;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.websocket.WebSockets;

public class MetricsWebsocketBroadcastHandler
implements Handler {
    public void handle(Context context) throws Exception {
        MetricsBroadcaster broadcaster = (MetricsBroadcaster)((Object)context.get(MetricsBroadcaster.class));
        ByteBufAllocator byteBufAllocator = (ByteBufAllocator)context.get(ByteBufAllocator.class);
        DropwizardMetricsConfig config = (DropwizardMetricsConfig)context.get(DropwizardMetricsConfig.class);
        MetricFilter filter = MetricFilter.ALL;
        if (config.getWebSocket().isPresent()) {
            filter = new RegexMetricFilter(config.getWebSocket().get().getIncludeFilter(), config.getWebSocket().get().getExcludeFilter());
        }
        WebSockets.websocketByteBufBroadcast((Context)context, (Publisher)broadcaster.map(new MetricRegistryJsonMapper(byteBufAllocator, filter)));
    }
}

