/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import ratpack.config.FileSystemBinding;

public class DefaultFileSystemBinding
implements FileSystemBinding {
    private final Path binding;
    private final Path dummyNonRootBinding;

    public DefaultFileSystemBinding(Path binding) {
        if (!binding.isAbsolute()) {
            throw new IllegalArgumentException("Filesystem binding must be absolute");
        }
        this.binding = binding;
        this.dummyNonRootBinding = binding.toString().equals("/") ? binding.resolve("dummy") : null;
    }

    @Override
    public Path getFile() {
        return this.binding;
    }

    @Override
    public Path file(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this.dummyNonRootBinding == null) {
            Path child = this.binding.resolve(path).normalize();
            if (child.startsWith(this.binding)) {
                return child;
            }
            return null;
        }
        Path child = this.dummyNonRootBinding.resolve(path).normalize();
        if (child.startsWith(this.dummyNonRootBinding)) {
            return this.binding.resolve(path).normalize();
        }
        return null;
    }

    @Override
    public FileSystemBinding binding(String path) {
        Path file = this.file(path);
        if (file != null) {
            return new DefaultFileSystemBinding(file);
        }
        return null;
    }

    public String toString() {
        return "FileSystemBinding[" + this.binding + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileSystemBinding that = (DefaultFileSystemBinding)o;
        try {
            return Files.isSameFile(this.binding, that.binding);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.binding.hashCode();
    }
}

