/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import ratpack.codahale.metrics.internal.BlockingExecTimingInterceptor;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.RequestOutcome;
import ratpack.http.Request;

public class RequestTimingHandler
implements Handler {
    private final Handler rest;

    public RequestTimingHandler(Handler rest) {
        this.rest = rest;
    }

    public void handle(final Context context) throws Exception {
        final MetricRegistry metricRegistry = (MetricRegistry)context.get(MetricRegistry.class);
        final Request request = context.getRequest();
        BlockingExecTimingInterceptor blockingExecTimingInterceptor = new BlockingExecTimingInterceptor(metricRegistry, request);
        context.addInterceptor((ExecInterceptor)blockingExecTimingInterceptor, (Action)new Action<Execution>(){

            public void execute(Execution execution) throws Exception {
                String tag = RequestTimingHandler.this.buildRequestTimerTag(request.getUri(), request.getMethod().getName());
                final Timer.Context timer = metricRegistry.timer(tag).time();
                context.onClose((Action)new Action<RequestOutcome>(){

                    public void execute(RequestOutcome thing) throws Exception {
                        timer.stop();
                    }
                });
                context.insert(new Handler[]{RequestTimingHandler.this.rest});
            }
        });
    }

    private String buildRequestTimerTag(String requestUri, String requestMethod) {
        return (requestUri.equals("/") ? "[root" : requestUri.replaceFirst("/", "[").replace("/", "][")) + "]~" + requestMethod + "~Request";
    }
}

