/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MulticastPublisher<T>
implements Publisher<T> {
    private final List<Subscriber<T>> subscribers = new CopyOnWriteArrayList<Subscriber<T>>();

    public void broadcast(T element) {
        for (Subscriber<T> subscriber : this.subscribers) {
            subscriber.onNext(element);
        }
    }

    public void subscribe(final Subscriber<T> s) {
        s.onSubscribe(new Subscription(){

            public void request(int n) {
                if (n != Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Back pressure is not supported by this Publisher.  Request with Integer.MAX_VALUE only");
                }
                MulticastPublisher.this.subscribers.add(s);
            }

            public void cancel() {
                MulticastPublisher.this.subscribers.remove(s);
            }
        });
    }
}

