/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInterceptor;
import ratpack.codahale.metrics.NamedHealthCheck;
import ratpack.codahale.metrics.internal.ConsoleReporterProvider;
import ratpack.codahale.metrics.internal.CsvReporterProvider;
import ratpack.codahale.metrics.internal.GaugeTypeListener;
import ratpack.codahale.metrics.internal.HealthCheckResultRenderer;
import ratpack.codahale.metrics.internal.HealthCheckResultsRenderer;
import ratpack.codahale.metrics.internal.JmxReporterProvider;
import ratpack.codahale.metrics.internal.MeteredMethodInterceptor;
import ratpack.codahale.metrics.internal.MetricsBroadcaster;
import ratpack.codahale.metrics.internal.RequestTimingHandler;
import ratpack.codahale.metrics.internal.StreamReporter;
import ratpack.codahale.metrics.internal.TimedMethodInterceptor;
import ratpack.func.Action;
import ratpack.guice.HandlerDecoratingModule;
import ratpack.guice.internal.GuiceUtil;
import ratpack.handling.Handler;

public class CodaHaleMetricsModule
extends AbstractModule
implements HandlerDecoratingModule {
    private boolean reportMetricsToJmx;
    private boolean reportMetricsToConsole;
    private File csvReportDirectory;
    private boolean healthChecksEnabled;
    private boolean jvmMetricsEnabled;
    private boolean reportMetricsToWebsocket;
    private boolean metricsEnabled;

    private boolean isMetricsEnabled() {
        return this.metricsEnabled || this.jvmMetricsEnabled || this.reportMetricsToConsole || this.reportMetricsToWebsocket || this.reportMetricsToJmx || this.csvReportDirectory != null;
    }

    protected void configure() {
        if (this.isMetricsEnabled()) {
            MetricRegistry metricRegistry = new MetricRegistry();
            this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
            MeteredMethodInterceptor meteredMethodInterceptor = new MeteredMethodInterceptor();
            this.requestInjection(meteredMethodInterceptor);
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Metered.class), new MethodInterceptor[]{meteredMethodInterceptor});
            TimedMethodInterceptor timedMethodInterceptor = new TimedMethodInterceptor();
            this.requestInjection(timedMethodInterceptor);
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Timed.class), new MethodInterceptor[]{timedMethodInterceptor});
            GaugeTypeListener gaugeTypeListener = new GaugeTypeListener(metricRegistry);
            this.bindListener(Matchers.any(), gaugeTypeListener);
            if (this.reportMetricsToJmx) {
                this.bind(JmxReporter.class).toProvider(JmxReporterProvider.class).asEagerSingleton();
            }
            if (this.reportMetricsToConsole) {
                this.bind(ConsoleReporter.class).toProvider(ConsoleReporterProvider.class).asEagerSingleton();
            }
            if (this.csvReportDirectory != null) {
                this.bind(File.class).annotatedWith((Annotation)Names.named((String)"ratpack.codahale.metrics.internal.CsvReporterProvider.csvReportDirectory")).toInstance((Object)this.csvReportDirectory);
                this.bind(CsvReporter.class).toProvider(CsvReporterProvider.class).asEagerSingleton();
            }
            if (this.reportMetricsToWebsocket) {
                this.bind(MetricsBroadcaster.class).in(Singleton.class);
                this.bind(StreamReporter.class).asEagerSingleton();
            }
        }
        if (this.healthChecksEnabled) {
            this.bind(HealthCheckRegistry.class).in(Singleton.class);
        }
        this.bind(HealthCheckResultRenderer.class).in(Singleton.class);
        this.bind(HealthCheckResultsRenderer.class).in(Singleton.class);
    }

    public CodaHaleMetricsModule metrics() {
        this.metricsEnabled = true;
        return this;
    }

    public CodaHaleMetricsModule healthChecks() {
        this.healthChecksEnabled = true;
        return this;
    }

    public CodaHaleMetricsModule jvmMetrics() {
        this.jvmMetricsEnabled = true;
        return this;
    }

    public CodaHaleMetricsModule websocket() {
        this.reportMetricsToWebsocket = true;
        return this;
    }

    public CodaHaleMetricsModule jmx() {
        this.reportMetricsToJmx = true;
        return this;
    }

    public CodaHaleMetricsModule console() {
        this.reportMetricsToConsole = true;
        return this;
    }

    public CodaHaleMetricsModule csv(File reportDirectory) {
        if (reportDirectory == null) {
            throw new IllegalArgumentException("reportDirectory cannot be null");
        }
        this.csvReportDirectory = reportDirectory;
        return this;
    }

    public Handler decorate(Injector injector, Handler handler) {
        if (this.healthChecksEnabled) {
            final HealthCheckRegistry registry = (HealthCheckRegistry)injector.getInstance(HealthCheckRegistry.class);
            GuiceUtil.eachOfType((Injector)injector, (TypeToken)TypeToken.of(NamedHealthCheck.class), (Action)new Action<NamedHealthCheck>(){

                public void execute(NamedHealthCheck healthCheck) throws Exception {
                    registry.register(healthCheck.getName(), (HealthCheck)healthCheck);
                }
            });
        }
        if (this.jvmMetricsEnabled) {
            MetricRegistry metricRegistry = (MetricRegistry)injector.getInstance(MetricRegistry.class);
            metricRegistry.registerAll((MetricSet)new GarbageCollectorMetricSet());
            metricRegistry.registerAll((MetricSet)new ThreadStatesGaugeSet());
            metricRegistry.registerAll((MetricSet)new MemoryUsageGaugeSet());
        }
        if (this.isMetricsEnabled()) {
            return new RequestTimingHandler(handler);
        }
        return handler;
    }
}

