/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.codahale.metrics.internal.MetricsBroadcaster;
import ratpack.launch.LaunchConfig;

public class WebSocketReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketReporter.class);
    private static final String DEFAULT_INTERVAL = "30";
    private final MetricsBroadcaster metricsBroadcaster;
    private final Clock clock = Clock.defaultClock();
    private final JsonFactory factory = new JsonFactory();

    @Inject
    public WebSocketReporter(MetricRegistry registry, MetricsBroadcaster metricsBroadcaster, LaunchConfig launchConfig) {
        super(registry, "websocket-reporter", MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.MILLISECONDS);
        this.metricsBroadcaster = metricsBroadcaster;
        String interval = launchConfig.getOther("metrics.scheduledreporter.interval", DEFAULT_INTERVAL);
        this.start(Long.valueOf(interval), TimeUnit.SECONDS);
    }

    public void report() {
        if (this.metricsBroadcaster.hasListeners()) {
            super.report();
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            JsonGenerator json = this.factory.createGenerator((OutputStream)out);
            json.writeStartObject();
            json.writeNumberField("timestamp", this.clock.getTime());
            this.writeTimers(json, timers);
            this.writeGauges(json, gauges);
            this.writeMeters(json, meters);
            this.writeCounters(json, counters);
            this.writeHistograms(json, histograms);
            json.writeEndObject();
            json.flush();
            json.close();
            this.metricsBroadcaster.broadcast(((Object)out).toString());
        }
        catch (IOException e) {
            LOGGER.warn("Exception encountered while reporting metrics: " + e.getLocalizedMessage());
        }
    }

    private void writeHistograms(JsonGenerator json, SortedMap<String, Histogram> histograms) throws IOException {
        json.writeArrayFieldStart("histograms");
        for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
            Histogram histogram = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            json.writeNumberField("count", histogram.getCount());
            Snapshot snapshot = histogram.getSnapshot();
            json.writeNumberField("min", this.convertDuration(snapshot.getMin()));
            json.writeNumberField("max", this.convertDuration(snapshot.getMax()));
            json.writeNumberField("mean", this.convertDuration(snapshot.getMean()));
            json.writeNumberField("stdDev", this.convertDuration(snapshot.getStdDev()));
            json.writeNumberField("50thPercentile", this.convertDuration(snapshot.getMedian()));
            json.writeNumberField("75thPercentile", this.convertDuration(snapshot.get75thPercentile()));
            json.writeNumberField("95thPercentile", this.convertDuration(snapshot.get95thPercentile()));
            json.writeNumberField("98thPercentile", this.convertDuration(snapshot.get98thPercentile()));
            json.writeNumberField("99thPercentile", this.convertDuration(snapshot.get99thPercentile()));
            json.writeNumberField("999thPercentile", this.convertDuration(snapshot.get999thPercentile()));
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeCounters(JsonGenerator json, SortedMap<String, Counter> counters) throws IOException {
        json.writeArrayFieldStart("counters");
        for (Map.Entry<String, Counter> entry : counters.entrySet()) {
            Counter counter = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            json.writeNumberField("count", counter.getCount());
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeMeters(JsonGenerator json, SortedMap<String, Meter> meters) throws IOException {
        json.writeArrayFieldStart("meters");
        for (Map.Entry<String, Meter> entry : meters.entrySet()) {
            Meter meter = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            json.writeNumberField("count", meter.getCount());
            json.writeNumberField("meanRate", this.convertRate(meter.getMeanRate()));
            json.writeNumberField("oneMinuteRate", this.convertRate(meter.getOneMinuteRate()));
            json.writeNumberField("fiveMinuteRate", this.convertRate(meter.getFiveMinuteRate()));
            json.writeNumberField("fifteenMinuteRate", this.convertRate(meter.getFifteenMinuteRate()));
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeTimers(JsonGenerator json, SortedMap<String, Timer> timers) throws IOException {
        json.writeArrayFieldStart("timers");
        for (Map.Entry<String, Timer> entry : timers.entrySet()) {
            Timer timer = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            json.writeNumberField("count", timer.getCount());
            json.writeNumberField("meanRate", this.convertRate(timer.getMeanRate()));
            json.writeNumberField("oneMinuteRate", this.convertRate(timer.getOneMinuteRate()));
            json.writeNumberField("fiveMinuteRate", this.convertRate(timer.getFiveMinuteRate()));
            json.writeNumberField("fifteenMinuteRate", this.convertRate(timer.getFifteenMinuteRate()));
            Snapshot snapshot = timer.getSnapshot();
            json.writeNumberField("min", this.convertDuration(snapshot.getMin()));
            json.writeNumberField("max", this.convertDuration(snapshot.getMax()));
            json.writeNumberField("mean", this.convertDuration(snapshot.getMean()));
            json.writeNumberField("stdDev", this.convertDuration(snapshot.getStdDev()));
            json.writeNumberField("50thPercentile", this.convertDuration(snapshot.getMedian()));
            json.writeNumberField("75thPercentile", this.convertDuration(snapshot.get75thPercentile()));
            json.writeNumberField("95thPercentile", this.convertDuration(snapshot.get95thPercentile()));
            json.writeNumberField("98thPercentile", this.convertDuration(snapshot.get98thPercentile()));
            json.writeNumberField("99thPercentile", this.convertDuration(snapshot.get99thPercentile()));
            json.writeNumberField("999thPercentile", this.convertDuration(snapshot.get999thPercentile()));
            json.writeEndObject();
        }
        json.writeEndArray();
    }

    private void writeGauges(JsonGenerator json, SortedMap<String, Gauge> gauges) throws IOException {
        json.writeArrayFieldStart("gauges");
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            Gauge gauge = entry.getValue();
            json.writeStartObject();
            json.writeStringField("name", entry.getKey());
            try {
                json.writeFieldName("value");
                json.writeObject(gauge.getValue());
            }
            catch (Exception e) {
                LOGGER.debug("Exception encountered while reporting [" + entry.getKey() + "]: " + e.getLocalizedMessage());
                json.writeNull();
            }
            json.writeEndObject();
        }
        json.writeEndArray();
    }
}

