/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.func.Action;

public class MetricsBroadcaster {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsBroadcaster.class);
    private final List<Action<String>> listeners = new CopyOnWriteArrayList<Action<String>>();

    public AutoCloseable register(final Action<String> subscriber) {
        this.listeners.add(subscriber);
        return new AutoCloseable(){

            @Override
            public void close() {
                MetricsBroadcaster.this.listeners.remove(subscriber);
            }
        };
    }

    public void broadcast(String message) {
        for (Action<String> listener : this.listeners) {
            try {
                listener.execute((Object)message);
            }
            catch (Exception e) {
                LOGGER.warn("Exception encountered while broadcasting metrics: " + e.getLocalizedMessage());
            }
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }
}

