/*
 * Decompiled with CFR 0.152.
 */
package ratpack.codahale.metrics.internal;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import ratpack.handling.Context;
import ratpack.handling.ProcessingInterceptor;
import ratpack.http.Request;

public class BackgroundProcessingTimingInterceptor
implements ProcessingInterceptor {
    public void init(Context context) {
    }

    public void intercept(ProcessingInterceptor.Type type, Context context, Runnable continuation) {
        if (type == ProcessingInterceptor.Type.BACKGROUND) {
            MetricRegistry metricRegistry = (MetricRegistry)context.get(MetricRegistry.class);
            Request request = context.getRequest();
            String tag = this.buildBackgroundTimerTag(request.getUri(), request.getMethod().getName());
            Timer.Context timer = metricRegistry.timer(tag).time();
            continuation.run();
            timer.stop();
        } else {
            continuation.run();
        }
    }

    private String buildBackgroundTimerTag(String requestUri, String requestMethod) {
        return (requestUri.equals("/") ? "[root" : requestUri.replaceFirst("/", "[").replace("/", "][")) + "]~" + requestMethod + "~Background";
    }
}

